% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_FindFeasibleMatrix.R
\name{findFeasibleMatrix_targetmean}
\alias{findFeasibleMatrix_targetmean}
\title{Creates a feasible starting matrix with a desired mean average degree}
\usage{
findFeasibleMatrix_targetmean(r, c, p, eps = 1e-09, targetmean = 0.3)
}
\arguments{
\item{r}{vector of row sums (nonnegative}

\item{c}{vector of column sums (nonnegative)}

\item{p}{matrix of probabilities (must be in [0,1]), matching the dimensions of r and c. Values of p=0 are interpreted that the corresponding matrix elements have to be 0. Note: p=1 does not force the corresponding matrix element to exist.}

\item{eps}{row and col sums can at most be different by eps.  Default 1e-9.}

\item{targetmean}{Average proportion of positive entries of the resulting matrix. Defaults to 0.3}
}
\description{
This extension of \code{\link{findFeasibleMatrix}} attempts to
create a feasible matrix where a certain proportion of the entries
is positive. There is no guarantee that this proportion is
achieved. If it is not possible then this matrix will report a warning
and simply return the matrix constructed by findFeasibleMatrix.
}

