% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multispatialccm.R
\name{multispatialccm}
\alias{multispatialccm}
\alias{multispatialccm,list-method}
\title{multispatial convergent cross mapping}
\usage{
\S4method{multispatialccm}{list}(
  data,
  cause,
  effect,
  libsizes,
  E = 3,
  tau = 0,
  k = E + 1,
  boot = 99,
  seed = 42,
  threads = length(libsizes),
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{number of time points used in prediction.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{k}{(optional) number of nearest neighbors used in prediction.}

\item{boot}{(optional) number of bootstraps to perform.}

\item{seed}{(optional) random seed.}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
multispatial convergent cross mapping
}
\examples{
set.seed(42)
obs = runif(15,0,0.1)
sim = vector("list",15)
for (i in seq_along(obs)){
  sim[[i]] = logistic_map(x = obs[i],y = obs[i],step = 15,beta_xy = 0.5,beta_yx = 0)
}
lst = list(x = do.call(cbind, lapply(sim, function(df) df$x)),
           y = do.call(cbind, lapply(sim, function(df) df$y)))
multispatialccm(lst,"x","y",libsizes = 5:15,E = c(7,2),k = 6,threads = 1)

}
\references{
Clark, A.T., Ye, H., Isbell, F., Deyle, E.R., Cowles, J., Tilman, G.D., Sugihara, G., 2015. Spatial convergent cross mapping to detect causal relationships from short time series. Ecology 96, 1174–1181.
}
