% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.seasons.R
\name{trakt.seasons.season}
\alias{trakt.seasons.season}
\title{Get a season of a show}
\usage{
trakt.seasons.season(target, seasons = 1, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}}

\item{seasons}{The season(s) to get. Defaults to 1. Use 0 for special episodes.}

\item{extended}{Use \code{full,images} to get season posters. Can be
\code{min} (default), \code{images}, \code{full}, \code{full,images}}
}
\value{
A \code{data.frame} containing all of a season's episodes
}
\description{
\code{trakt.seasons.season} pulls a season's full data.
Similar to \link{trakt.seasons.summary}, but this function returns full data for
a single season, i.e. all the episodes of the season.
See \href{http://docs.trakt.apiary.io/#introduction/extended-info}{the API docs} for possible values of
\code{extended} to customize output amount.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/seasons/season/get-single-season-for-a-show}{the trakt API docs for further info}.
If you want to quickly gather data of multiple seasons, see \link[tRakt]{trakt.get_all_episodes}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.seasons <- trakt.seasons.season("breaking-bad", 1)
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

