% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-joins.R, R/VERBS-anti_join.R,
%   R/VERBS-full_join.R, R/VERBS-inner_join.R, R/VERBS-left_join.R,
%   R/VERBS-mutate_join.R, R/VERBS-right_join.R, R/VERBS-semi_join.R
\name{joins}
\alias{joins}
\alias{anti_join.ExprBuilder}
\alias{anti_join.data.table}
\alias{full_join.ExprBuilder}
\alias{full_join.data.table}
\alias{inner_join.ExprBuilder}
\alias{inner_join.data.table}
\alias{left_join.ExprBuilder}
\alias{left_join.data.table}
\alias{mutate_join}
\alias{mutate_join.ExprBuilder}
\alias{mutate_join.EagerExprBuilder}
\alias{mutate_join.data.table}
\alias{right_join.ExprBuilder}
\alias{right_join.data.table}
\alias{semi_join.ExprBuilder}
\alias{semi_join.data.table}
\title{Joining verbs}
\usage{
\method{anti_join}{ExprBuilder}(x, y, ...)

\method{anti_join}{data.table}(x, ..., .expr = FALSE)

\method{full_join}{ExprBuilder}(x, y, ..., sort = TRUE, allow = TRUE, .parent_env)

\method{full_join}{data.table}(x, ...)

\method{inner_join}{ExprBuilder}(x, y, ...)

\method{inner_join}{data.table}(x, ..., .expr = FALSE)

\method{left_join}{ExprBuilder}(x, y, ..., nomatch, mult, roll, rollends, .parent_env)

\method{left_join}{data.table}(x, y, ..., allow = FALSE, .expr = FALSE)

mutate_join(x, y, ...)

\method{mutate_join}{ExprBuilder}(
  x,
  y,
  ...,
  .SDcols,
  mult,
  roll,
  rollends,
  allow = FALSE,
  .by_each = NULL,
  .parent_env
)

\method{mutate_join}{EagerExprBuilder}(x, ..., .parent_env = rlang::caller_env())

\method{mutate_join}{data.table}(x, y, ...)

\method{right_join}{ExprBuilder}(x, y, ..., which, nomatch, mult, roll, rollends)

\method{right_join}{data.table}(x, ..., allow = FALSE, .expr = FALSE)

\method{semi_join}{ExprBuilder}(x, y, ..., allow = FALSE, .eager = FALSE)

\method{semi_join}{data.table}(x, y, ..., allow = FALSE, .eager = FALSE)
}
\arguments{
\item{x}{An \link{ExprBuilder} instance.}

\item{y}{A \link[data.table:data.table-class]{data.table::data.table} or, for some verbs (see details), a call to
\code{\link[=nest_expr]{nest_expr()}}.}

\item{...}{Expressions for the \code{on} part of the join.}

\item{.expr}{If the input is a \code{data.table} and \code{.expr} is \code{TRUE}, an instance of
\link{EagerExprBuilder} will be returned. Useful if you want to add clauses to \code{j}, e.g. with
\link{mutate-table.express}.}

\item{sort}{Passed to \link[data.table:merge]{data.table::merge}.}

\item{allow}{Passed as \code{\link[data.table:data.table]{data.table}}'s \code{allow.cartesian}.}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}.}

\item{nomatch, mult, roll, rollends}{See \link[data.table:data.table]{data.table::data.table}.}

\item{.SDcols}{For \code{mutate_join}. See the details below.}

\item{.by_each}{For \code{mutate_join}. See the details below.}

\item{which}{If \code{TRUE}, return the row numbers that matched in \code{x} instead of the result of the
join.}

\item{.eager}{For \code{semi_join}. If \code{TRUE}, it uses \code{\link[=nest_expr]{nest_expr()}} to build an expression like
\href{https://stackoverflow.com/a/18971223/5793905}{this} instead of the default one. This uses the
captured \code{data.table} eagerly, so use \code{\link[=chain]{chain()}} when needed. The default is lazy.}
}
\description{
Two-table joins. Check the
\href{https://asardaes.github.io/table.express/articles/joins.html}{"Joining verbs" vignette} for more
information.
}
\details{
The following joins support \code{\link[=nest_expr]{nest_expr()}} in \code{y}:
\itemize{
\item \code{anti_join}
\item \code{inner_join}
\item \code{right_join}
}

The \code{full_join} method is really a wrapper for \code{data.table::merge} that specifies \code{all = TRUE}.
The expression in \code{x} gets evaluated, merged with \code{y}, and the result is captured in a new
\link{ExprBuilder}. Useful in case you want to keep building expressions after the merge.
}
\section{Mutating join}{


The \link{ExprBuilder} method for \code{mutate_join} implements the idiom described in \href{https://stackoverflow.com/a/54313203/5793905}{this link}. The columns specified in \code{.SDcols} are
those that will be added to \code{x} from \code{y}. The specification can be done by:
\itemize{
\item Using \link[tidyselect:language]{tidyselect::select_helpers}.
\item Passing a character vector. If the character is named, the names are taken as the new column
names for the values added to \code{x}.
\item A list, using \code{\link[base:list]{base::list()}} or \code{.()}, containing:
\itemize{
\item Column names, either as characters or symbols.
\item Named calls expressing how the column should be summarized/modified before adding it to
\code{x}.
}
}

The last case mentioned above is useful when the join returns many rows from \code{y} for each row
in \code{x}, so they can be summarized while joining. The value of \code{by} in the join depends on what
is passed to \code{.by_each}:
\itemize{
\item If \code{NULL} (the default), \code{by} is set to \code{.EACHI} if a call is detected in any of the
expressions from the list in \code{.SDcols}
\item If \code{TRUE}, \code{by} is always set to \code{.EACHI}
\item If \code{FALSE}, \code{by} is never set to \code{.EACHI}
}
}

\examples{

lhs <- data.table::data.table(x = rep(c("b", "a", "c"), each = 3),
                              y = c(1, 3, 6),
                              v = 1:9)

rhs <- data.table::data.table(x = c("c", "b"),
                              v = 8:7,
                              foo = c(4, 2))


rhs \%>\%
    anti_join(lhs, x, v)


lhs \%>\%
    inner_join(rhs, x)


# creates new data.table
lhs \%>\%
    left_join(rhs, x)


# would modify lhs by reference
lhs \%>\%
    start_expr \%>\%
    mutate_join(rhs, x, .SDcols = c("foo", rhs.v = "v"))

# would modify rhs by reference, summarizing 'y' before adding it.
rhs \%>\%
    start_expr \%>\%
    mutate_join(lhs, x, .SDcols = .(y = mean(y)))


# creates new data.table
lhs \%>\%
    right_join(rhs, x)


# keep only columns from lhs
lhs \%>\%
    semi_join(rhs, x)

}
\seealso{
\link[data.table:data.table]{data.table::data.table}, \link[dplyr:mutate-joins]{dplyr::join}
}
