% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{tablerAlert}
\alias{tablerAlert}
\title{Create a Boostrap 4 alert}
\usage{
tablerAlert(..., title = NULL, status, icon = NULL, closable = TRUE)
}
\arguments{
\item{...}{Alert content.}

\item{title}{Alert title.}

\item{status}{Alert status. See \url{https://preview.tabler.io/docs/colors.html}.}

\item{icon}{Alert icon.}

\item{closable}{Whether to close the alert. TRUE by default.}
}
\description{
Build a tabler alert
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerAlert(
      title = "Alert",
      "Lorem ipsum dolor sit amet, consectetur
      adipisicing elit. Lorem ipsum dolor sit
      amet, consectetur adipisicing elit.
      Lorem ipsum dolor sit amet, consectetur
      adipisicing elit.",
      icon = "alert-triangle",
      status = "info"
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
