% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.tabnet_fit}
\alias{autoplot.tabnet_fit}
\alias{autoplot.tabnet_pretrain}
\title{Plot tabnet_fit model loss along epochs}
\usage{
autoplot.tabnet_fit(object, ...)

autoplot.tabnet_pretrain(object, ...)
}
\arguments{
\item{object}{A \code{tabnet_fit} or \code{tabnet_pretrain} object as a result of
\code{\link[=tabnet_fit]{tabnet_fit()}} or \code{\link[=tabnet_pretrain]{tabnet_pretrain()}}.}

\item{...}{not used.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot tabnet_fit model loss along epochs
}
\details{
Plot the training loss along epochs, and validation loss along epochs if any.
A dot is added on epochs where model snapshot is available, helping
the choice of \code{from_epoch} value for later model training resume.
}
\examples{
\donttest{
library(ggplot2)
data("attrition", package = "modeldata")
attrition_fit <- tabnet_fit(Attrition ~. , data=attrition, valid_split=0.2, epoch=15)

# Plot the model loss over epochs
autoplot(attrition_fit)
}

}
