% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{chord_arpeggiate}
\alias{chord_arpeggiate}
\title{Arpeggiate a chord}
\usage{
chord_arpeggiate(chord, n = 0, by = c("note", "chord"),
  broken = FALSE, collapse = FALSE)
}
\arguments{
\item{chord}{character, a single chord.}

\item{n}{integer, number of steps, negative indicates reverse direction (decreasing pitch).}

\item{by}{whether each of the \code{n} steps refers to individual notes in the chord (an inversion) or raising the entire chord in its given position by one octave.}

\item{broken}{logical, return result as an arpeggio of broken chords.}

\item{collapse}{logical, collapse result into a single string ready for phrase construction.}
}
\value{
character
}
\description{
Create an arpeggio from a chord.
}
\details{
This function is based on \code{chord_invert}. If \code{n = 0} then \code{chord} is returned immediately; other arguments are ignored.
}
\examples{
chord_arpeggiate("ce_gb_", 2)
chord_arpeggiate("ce_gb_", -2)
chord_arpeggiate("ce_gb_", 2, by = "chord")
chord_arpeggiate("ce_gb_", 1, broken = TRUE, collapse = TRUE)
}
