% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{double-bracket}
\alias{double-bracket}
\alias{[[.noteworthy}
\alias{[[.noteinfo}
\alias{[[.music}
\alias{[[.lyrics}
\alias{[[<-.noteworthy}
\alias{[[<-.noteinfo}
\alias{[[<-.music}
\alias{[[<-.lyrics}
\title{Double bracket methods for tabr classes}
\usage{
\method{[[}{noteworthy}(x, i)

\method{[[}{noteinfo}(x, i)

\method{[[}{music}(x, i)

\method{[[}{lyrics}(x, i)

\method{[[}{noteworthy}(x, i) <- value

\method{[[}{noteinfo}(x, i) <- value

\method{[[}{music}(x, i) <- value

\method{[[}{lyrics}(x, i) <- value
}
\arguments{
\item{x}{object.}

\item{i}{index.}

\item{value}{values to assign at index.}
}
\description{
Double bracket indexing and assignment. See \code{\link[=tabr-methods]{tabr-methods()}} for more details
on methods for tabr classes.
}
\examples{
# noteworthy class examples
x <- as_noteworthy("a, b, c ce_g")
x[[3]]
x[[2]] <- paste0(transpose(x[2], 1), "~")
x

# noteinfo class examples
x <- as_noteinfo(c("4-", "t8(", "t8)", "t8x"))
x[[3]]
x[[3]] <- c("t8]")
x

# music class examples
x <- as_music("c,~4 c,1 c'e_'g'4-.*2")
x[[3]]
x[[3]] <- "c'e'g'8"
x
}
\seealso{
\code{\link[=tabr-methods]{tabr-methods()}}, \code{\link[=note-metadata]{note-metadata()}}
}
