% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{OccurrenceMatrix-class}
\alias{OccurrenceMatrix-class}
\title{Co-occurrence matrix}
\description{
An S4 class to represent a co-occurrence matrix.
}
\details{
A co-occurrence matrix is a symetric matrix with zeros on its main diagonal,
 which works out how many times (expressed in percent) each pairs of taxa
 occur together in at least one sample.
}
\note{
This class extends the \code{base} \link[base]{matrix}.
}
\examples{
# Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10, byrow = TRUE)

# Coerce counts to frequencies
B <- as(A1, "FrequencyMatrix")

# Row sums are internally stored before coercing to a frequency matrix
totals(B) # Get row sums

# This allows to restore the source data
A2 <- as(B, "CountMatrix")
all(A1 == A2)

# Coerce to a co-occurrence matrix
C <- as(B, "OccurrenceMatrix")
}
\seealso{
\link[base]{matrix}

Other abundance matrix: \code{\link{CountMatrix-class}},
  \code{\link{FrequencyMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{abundance matrix}
