% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/extract.R
\docType{methods}
\name{geography}
\alias{geography}
\alias{get_features}
\alias{get_features-method}
\alias{get_coordinates}
\alias{get_coordinates-method}
\alias{set_coordinates<-}
\alias{set_coordinates-method}
\alias{get_epsg}
\alias{get_epsg-method}
\alias{set_epsg<-}
\alias{set_epsg-method}
\alias{get_coordinates,AbundanceMatrix-method}
\alias{get_epsg,AbundanceMatrix-method}
\alias{get_features,AbundanceMatrix-method}
\alias{set_coordinates<-,AbundanceMatrix-method}
\alias{set_coordinates,AbundanceMatrix-method}
\alias{set_epsg<-,AbundanceMatrix-method}
\alias{set_epsg,AbundanceMatrix-method}
\title{Spatial Information}
\usage{
get_features(object)

get_coordinates(object)

set_coordinates(object) <- value

get_epsg(object)

set_epsg(object) <- value

\S4method{get_coordinates}{AbundanceMatrix}(object)

\S4method{get_epsg}{AbundanceMatrix}(object)

\S4method{get_features}{AbundanceMatrix}(object)

\S4method{set_coordinates}{AbundanceMatrix}(object) <- value

\S4method{set_epsg}{AbundanceMatrix}(object) <- value
}
\arguments{
\item{object}{An object from which to get or set element(s).}

\item{value}{A possible value for the element(s) of \code{object} (see
below).}
}
\description{
Experimental tools to deal with spatial information.
}
\section{Set coordinates}{

 An attempt is made to interpret the argument \code{value} in a way suitable
 for geographic coordinates. If \code{value} is a:
 \describe{
  \item{\code{list}}{containing components "\code{x}", "\code{y}" and
  "\code{z}", these are used to define coordinates (longitude, latitude and
  elevation, respectively). If "\code{z}" is missing, the vertical
  coordinates will be ignored (and \code{NA} will be generated).}
  \item{\code{matrix} or \code{data.frame} with two or more columns}{the
  first is assumed to contain the \code{x} values, the second the \code{y}
  and the third the \code{z} values. \emph{Note} that if \code{value} has
  columns named "\code{x}", "\code{y}" and "\code{z}", these columns will be
  used. If \code{value} has only two columns or has columns named "\code{x}"
  and "\code{y}" but not "\code{z}", the vertical coordinates will be ignored
  (and \code{NA} will be generated).}
 }

 \code{get_features} converts an \code{AbundanceMatrix} object to a
 collection of features (i.e. a\code{\link{data.frame}} with
 dates and coordinates columns) that can be used for spatial manipulation
 with \pkg{sf}.
}

\examples{
## Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10, byrow = TRUE)

## Set geographic coordinates
set_epsg(A1) <- 4326
set_coordinates(A1) <- list(X = sample(0:10, 10, TRUE),
                            Y = sample(0:10, 10, TRUE))
get_coordinates(A1)

\donttest{
## Convert to a sf object (the sf package must be installed on your machine)
# feat <- get_features(A1)
# sf::st_as_sf(feat, crs = 4326, coords = c("X", "Y"), dim = "XY",
#              remove = FALSE, na.fail = TRUE)
}
}
\author{
N. Frerebeau
}
\concept{geography}
