% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DiversityIndex-class}
\alias{DiversityIndex-class}
\alias{.DiversityIndex}
\alias{HeterogeneityIndex-class}
\alias{.HeterogeneityIndex}
\alias{EvennessIndex-class}
\alias{.EvennessIndex}
\alias{RichnessIndex-class}
\alias{.RichnessIndex}
\alias{CompositionIndex-class}
\alias{.CompositionIndex}
\alias{RarefactionIndex-class}
\alias{.RarefactionIndex}
\title{Diversity Index}
\description{
An S4 class to represent a diversity measure.
}
\section{Slots}{

\describe{
\item{\code{names}}{A \code{\link{character}} vector giving the sample names.}

\item{\code{size}}{A \code{\link{integer}} vector giving the sample sizes.}

\item{\code{simulation}}{A four columns \code{\link{numeric}} matrix giving the diversity
measures for the simulated assemblage (sample \code{size}, \code{mean} estimate,
\code{lower} and \code{upper} boundaries of the confidence interval).}

\item{\code{method}}{A \code{\link{character}} string specifying the method used.}
}}

\note{
This class inherits from base \code{\link{numeric}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is an \code{DiversityIndex} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\author{
N. Frerebeau
}
\concept{classes}
