% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_heatmap.R
\docType{methods}
\name{plot_heatmap}
\alias{plot_heatmap}
\alias{matrigraphe}
\alias{plot_heatmap-method}
\alias{plot_heatmap,matrix-method}
\alias{plot_heatmap,data.frame-method}
\alias{plot_heatmap,dist-method}
\title{Heatmap}
\usage{
plot_heatmap(object, ...)

\S4method{plot_heatmap}{matrix}(object, diag = TRUE, upper = TRUE, lower = TRUE, freq = FALSE)

\S4method{plot_heatmap}{data.frame}(object, diag = TRUE, upper = TRUE, lower = TRUE, freq = FALSE)

\S4method{plot_heatmap}{dist}(object, diag = FALSE, upper = FALSE, lower = !upper)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{lower}{A \code{\link{logical}} scalar indicating whether the lower triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{freq}{A \code{\link{logical}} scalar indicating whether relative frequency
should be used instead of counts (absolute frequency).}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a heatmap.
}
\examples{
data("cantabria")

## Plot matrix diagram...
plot_heatmap(cantabria)
plot_heatmap(cantabria, freq = TRUE)

## Presence/absence data
inc <- sample(0:1, size = 100, replace = TRUE)
bin <- matrix(data = as.logical(inc), nrow = 10, ncol = 10)

plot_heatmap(bin) +
  khroma::scale_fill_logical()
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.
}
\seealso{
\code{\link[=pvi]{pvi()}}

Other plot methods: 
\code{\link{plot_bar}},
\code{\link{plot_diversity}},
\code{\link{plot_line}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
