% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_heatmap.R
\docType{methods}
\name{plot_heatmap}
\alias{plot_heatmap}
\alias{plot_heatmap-method}
\alias{plot_heatmap,matrix-method}
\alias{plot_heatmap,data.frame-method}
\alias{plot_heatmap,dist-method}
\title{Heatmap}
\usage{
plot_heatmap(object, ...)

\S4method{plot_heatmap}{matrix}(
  object,
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = TRUE,
  upper = TRUE,
  lower = TRUE,
  freq = FALSE,
  margin = 1,
  fixed_ratio = TRUE,
  axes = TRUE,
  legend = TRUE,
  ...
)

\S4method{plot_heatmap}{data.frame}(
  object,
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = TRUE,
  upper = TRUE,
  lower = TRUE,
  freq = FALSE,
  margin = 1,
  fixed_ratio = TRUE,
  axes = TRUE,
  legend = TRUE,
  ...
)

\S4method{plot_heatmap}{dist}(
  object,
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = FALSE,
  upper = FALSE,
  lower = !upper,
  axes = TRUE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{col}{A vector of colors.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{lower}{A \code{\link{logical}} scalar indicating whether the lower triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{freq}{A \code{\link{logical}} scalar indicating whether conditional proportions
given \code{margins} should be used (i.e. entries of \code{object}, divided by the
appropriate marginal sums).}

\item{margin}{An \code{\link{integer}} vector giving the margins to split by:
\code{1} indicates individuals/rows (the default), \code{2} indicates
variables/columns. Only used if \code{freq} is \code{TRUE}.}

\item{fixed_ratio}{A \code{\link{logical}} scalar: should a fixed aspect ratio (1) be
used?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot? It will
omit labels where they would abut or overlap previously drawn labels.}

\item{legend}{A \code{\link{logical}} scalar: should a legend be displayed?}
}
\value{
\code{plot_heatmap()} is called for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
}
\description{
Plots a heatmap.
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Plot raw data
plot_heatmap(cantabria)

## Plot conditional proportions
plot_heatmap(cantabria, freq = TRUE, margin = 1)
plot_heatmap(cantabria, freq = TRUE, margin = 2)
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_rank}()},
\code{\link{plot_rarefaction}},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
