% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/occurrence.R
\docType{methods}
\name{occurrence}
\alias{occurrence}
\alias{occurrence-method}
\alias{occurrence,matrix-method}
\alias{occurrence,data.frame-method}
\title{Co-Occurrence}
\usage{
occurrence(object, ...)

\S4method{occurrence}{matrix}(object)

\S4method{occurrence}{data.frame}(object)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Currently not used.}
}
\value{
A \link[stats:dist]{stats::dist} object.
}
\description{
Co-Occurrence
}
\details{
A co-occurrence matrix is a symmetric matrix with zeros on its main
diagonal, which works out how many times each pairs of taxa/types occur
together in at least one sample.
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Plot spot diagram of a co-occurrence matrix
occ <- occurrence(cantabria)
plot_spot(occ)
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{plot_diversity}},
\code{\link{plot_rarefaction}},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
