% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_spread}
\alias{tab_spread}
\title{Spread a tab, passing a tab variable to column}
\usage{
tab_spread(
  tabs,
  spread_vars,
  names_prefix,
  names_sort = FALSE,
  totname = "Total"
)
}
\arguments{
\item{tabs}{A \code{tibble} of class \code{tab}, made with \code{\link{tab}},
\code{\link{tab_many}} or \code{\link{tab_plain}}.}

\item{spread_vars}{<\link[tidyr:tidyr_tidy_select]{tidy-select}>  The tab variables
to pass to column, with a syntax of type \code{c(var1, var2, ...)}.}

\item{names_prefix}{String added to the start of every variable name.}

\item{names_sort}{If no \code{names_prefix} is given, new names takes the form
\code{spread_var}_\code{col_var_level}. Should then the column names be sorted ?
If \code{FALSE}, the default, column names are ordered by first appearance.}

\item{totname}{The new name of the total rows, as a single string.}
}
\value{
A \code{tibble} of class \code{tab}, with less rows and more columns.
}
\description{
Spread a tab, passing a tab variable to column
}
\examples{
\donttest{ data <- forcats::gss_cat \%>\% dplyr::filter(year \%in\% c(2000, 2014))

tabs <-
  tab(data, relig, marital, c(year, race), pct = "row", totaltab = "no",
      color = "diff", tot = "row", rare_to_other = TRUE)

tabs \%>\%
  dplyr::select(year, race, relig, Married) \%>\%
  tab_spread(race)
  }
}
