% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_xl.R
\name{tab_xl_confidential}
\alias{tab_xl_confidential}
\title{Excel output for tabxplor tables with confidentiality rules.}
\usage{
tab_xl_confidential(
  tabs,
  path = NULL,
  replace = NULL,
  open = rlang::is_interactive(),
  n_min = 5,
  pct_max = 0.95,
  recalculate_totcols = NULL,
  var_labels = character(),
  colnames_rotation = 0,
  colwidth = 10,
  sheets = "unique",
  print_color_legend = TRUE,
  titles,
  hide_near_zero = "auto",
  color_type = "text"
)
}
\arguments{
\item{tabs}{A table made with \code{\link{tab}}, \code{\link{tab_many}} or
\code{\link{tab_plain}}, or a list of such tables.}

\item{path, replace, open}{The name, and possibly the path, of the Excel file to
create (possibly without the .xlsx extension). Default path to temporary directory.
Set global option \code{"tabxplor.export_dir"} with \code{link[base:options]{options}}
to change default directory. By default replace is \code{TRUE} when \code{path} is provided,
\code{FALSE} when \code{path} is not provided.
Use \code{replace = TRUE} to overwrite existing files. Use \code{open = FALSE}
if you don't want to automatically open the tables in Excel (or another
software associated with .xlsx files).}

\item{n_min}{The total count under which a column or row doesnt respect statistical
confidentiality. Default to 5.}

\item{pct_max}{The row or column percentage above which, knowing the column category,
it becomes possible to guess the row category, or the other way round.
Default to 0.95 (95\%).}

\item{recalculate_totcols}{By default, total columns are recalculated from counts if
there are many \code{col_vars} but only one total column. Provide a logical vector the
length of the number of tables, or a single logical, to choose the wanted behavior.
The fastest way to do it is to use \code{tab_many()} with \code{totcol = "each"} before.}

\item{var_labels}{The description of all the variables, necessary to assess that
the tables don't break confidentiality rules, as a character vector of the type
\code{c('variable1' = 'description of the variable', 'variable2' = ...)}}

\item{colnames_rotation}{Rotate the names of columns to an angle (in degrees).}

\item{colwidth}{The standard width for numeric columns, as a number.
Default to 10.}

\item{sheets}{The Excel sheets options :
\itemize{
\item \code{"unique"}: all tables are on the same sheet
\item \code{"tabs"}: a new sheet is created for each table
\item \code{"auto"}: subsequent tables with the same columns are printed on the
same sheets
}}

\item{print_color_legend}{Should the color legends be printed with the subtexts ?}

\item{titles}{The titles of the different tables, as a character vector. When missing
titles are given based on the names of the variables.}

\item{hide_near_zero}{By default all cells displayed as 0 (even rounded)
turn pale grey, to make the distribution of empty cells (and other cells) more visible.
Provide a number to turn grey every cell below it. Set to \code{Inf} not to use
this feature.}

\item{color_type}{By default, the text is colored. Set to \code{"bg"} to color
the background instead.}
}
\value{
The table(s) with formatting and colors in an Excel file, as a side effect.
Invisibly returns \code{tabs}.
}
\description{
Excel output for tabxplor tables, with colors to show if counts
and percentages respect statistical confidentiality rules. Don't forget to provide
\code{subtext = c("Source : description of the source of the data")} in \code{tab} or \code{tab_many},
otherwise it is not possible to assess, for your reader, which confidentiality rules
applies. For the same reason, you must supply a description of all variables in
\code{var_labels}.
}
\examples{
\donttest{
forcats::gss_cat |>
  tab(race, marital, year, pct = "row", color = "diff",
     subtext = c('Source : National Opinion Research Center, General Social Survey.')) |>
  tab_xl_confidential(titles = "Marital status by race",
     var_labels = c("marital" = "marital status", "race" = "race",
     "year" = "year of survey"))
  }
}
