% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_ci}
\alias{tab_ci}
\title{Add confidence intervals to a \code{\link[tabxplor]{tab}}}
\usage{
tab_ci(
  tabs,
  ci = "auto",
  comp = NULL,
  conf_level = 0.95,
  color = "no",
  visible = FALSE,
  method_cell = "wilson",
  method_diff = "ac"
)
}
\arguments{
\item{tabs}{A \code{tibble} of class \code{tab} made with \code{\link{tab_plain}} or
\code{\link{tab_many}}.}

\item{ci}{The type of ci to calculate. Set to "cell" to calculate absolute confidence
intervals. Set to "diff" to calculate the confidence intervals of the difference
between a cell and the relative total cell (or the reference cell,
when \code{ref} is not \code{"tot"} in \code{\link{tab_plain}} or \code{\link{tab_num}}).
By default, "diff" ci are calculated for means and row and col percentages,
"cell" ci for frequencies ("all", "all_tabs"). By default, with \code{ci = "cell"},
the result is printed in the \verb{[inf;sup]} form. Set
\code{options("tabxplor.ci_print" = "moe")} to print \code{pct +- moe} instead.}

\item{comp}{Comparison level. When \code{tab_vars} are present, should the
contributions to variance be calculated for each subtable/group (by default,
\code{comp = "tab"}) ? Should they be calculated for the whole table
(\code{comp = "all"}) ?
\code{comp} must be set once and for all the first time you use \code{\link{tab_plain}},
\code{\link{tab_num}} or \code{\link{tab_chi2}} with rows, or \code{\link{tab_ci}}.}

\item{conf_level}{The confidence level, as a single numeric between 0 and 1.
Default to 0.95 (95\%).}

\item{color}{The type of colors to print, as a single string.
\itemize{
\item \code{"no"}: by default, no colors are printed
\item \code{"diff_ci"}: color pct and means based on cells differences from totals
or first cells, removing coloring when the confidence interval of this difference
is higher than the difference itself
\item \code{"after_ci"}: idem, but cut off the confidence interval from the
difference
}}

\item{visible}{By default confidence intervals are calculated and used to set colors,
but not printed. Set to \code{TRUE} to print them in the result.}

\item{method_cell}{Character string specifying which method to use with percentages
for \code{ci = "cell"}. This can be one out of:
"wald", "wilson", "wilsoncc", "agresti-coull", "jeffreys", "modified wilson",
"modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting", "pratt",
"midp", "lik" and "blaker". Defaults to "wilson".
See \code{\link[DescTools:BinomCI]{BinomCI}}.}

\item{method_diff}{Character string specifying which method to use with percentages
for \code{ci = "diff"}. This can be one out of: "wald", "waldcc", "ac", "score",
"scorecc", "mn", "mee", "blj", "ha", "hal", "jp". Defaults to "ac", Wald interval with
the adjustment according to Agresti, Caffo for difference in proportions and
independent samples. See \code{\link[DescTools:BinomDiffCI]{BinomDiffCI}}.}
}
\value{
A \code{tibble} of class \code{tab}, colored based on differences (from
totals/first cells) and confidence intervals.
}
\description{
Add confidence intervals to a \code{\link[tabxplor]{tab}}
}
\examples{
# A typical workflow with tabxplor step-by-step functions :
\donttest{
data <- dplyr::starwars \%>\%
  tab_prepare(sex, hair_color, gender, other_if_less_than = 5,
              na_drop_all = sex)

data \%>\%
  tab_plain(sex, hair_color, gender, tot = c("row", "col"),
    pct = "row", comp = "all") \%>\%
    tab_ci("diff", color = "after_ci")
  }
}
