% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_tac}
\alias{load_tac}
\title{Loads TAC from file for use by other functions (default is PMOD .tac format)}
\usage{
load_tac(filename, format = "PMOD", acqtimes = NULL,
  time_unit = NULL, activity_unit = NULL)
}
\arguments{
\item{filename}{(e.g. "participant01.tac")}

\item{format}{A character string, with options listed above (e.g. "PMOD")}

\item{acqtimes}{Filename for a .acqtimes file (as in PMOD), required for 
format="voistat"}

\item{time_unit}{NULL if in file (e.g. PMOD .tac), or set to "seconds" or 
"minutes" if not in file or to override file}

\item{activity_unit}{NULL if in file (e.g. PMOD .tac), or set to "kBq/cc", 
"Bq/cc", "nCi/cc"}
}
\value{
tac object
}
\description{
This is the main function for loading an individual participant's TAC data.
The minimal required information within the supplied files is the start and 
stop times and a time unit (either seconds or minutes), as well as the 
activity values for 1 or more ROIs, and units for activity. The currently 
supported formats (with the corresponding format argument), include:
\itemize{
  \item "PMOD": PMOD .tac files
  \item "voistat": PMOD TAC .voistat files used in combination with PMOD 
         .acqtimes file for start/stop times.
  \item "magia": magia pipeline .mat tac file
  \item "DFT": Turku PET Centre's DFT format
}
}
\examples{
f_raw_tac <- system.file("extdata", "AD06.tac", package="tacmagic") 
tac <- load_tac(f_raw_tac)

}
\seealso{
Other Loading functions: \code{\link{as.tac}},
  \code{\link{load_voistat}}, \code{\link{load_vol}}
}
\concept{Loading functions}
