% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_voistat}
\alias{load_voistat}
\title{Reads PMOD .voistat files and optionally merges volume-weighted ROIs}
\usage{
load_voistat(filename, ROI_def = NULL, model = "VALUE")
}
\arguments{
\item{filename}{(e.g. participant_logan.voistat)}

\item{ROI_def}{Optional ROI definitions to combine ROIs (e.g. roi_ham_pib())}

\item{model}{A string to name the variable being extracted, e.g. "Logan_DVR"}
}
\value{
data.frame with loaded model data in specified combined weighted ROIs
}
\description{
PMOD can produce .voistat files with the average model values by ROI for 
its voxelwise binding potential (BPnd) models, such as Logan, SRTM, etc.
This function reads the .voistat file and returns a data.frame with the
ROI as rows and the model value as the column. Optionally, the ROIs can be
combined into larger ROIs if ROI_def is specified, just as with TAC loading.
}
\examples{
f <- system.file("extdata", "AD06_BPnd_BPnd_Logan.voistat", 
                 package="tacmagic")
vs <- load_voistat(f, ROI_def=roi_ham_pib(), model="Logan")
}
\seealso{
Other Loading functions: \code{\link{as.tac}},
  \code{\link{load_tac}}, \code{\link{load_vol}}
}
\concept{Loading functions}
