% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_stats.R
\name{z}
\alias{z}
\title{Convert numeric vector to z-values}
\usage{
z(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A vector of z-values of the same length as \code{x}.
}
\description{
A trivial scaling function. You might as well use \link[base]{scale}, which allows
arbitrary centers and scales, but returns a \code{matrix} by default.
}
\examples{
x      <- rnorm(500, mean = 10, sd = 5)
z_vals <- z(x)
round(c(mean = mean(z_vals), sd = sd(z_vals)), 2)
}
