% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{clean_tags}
\alias{clean_tags}
\title{Remove the 'tags' attribute from an object}
\usage{
clean_tags(obj, envir = parent.frame())
}
\arguments{
\item{obj}{The object to remove tags from}

\item{envir}{The environment in which to look for the object}
}
\value{
No return value.
}
\description{
This function removes the 'tags' attribute from an object, effectively
removing all tags attached to the object. If the object does not have a
'tags' attribute, the function simply returns without modifying the object.
}
\examples{
# create an object and add some tags
my_vec <- c(1, 2, 3)
add_tags(my_vec, "important", "numeric")

# remove the tags from the object
clean_tags(my_vec)

}
