% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{tags}
\alias{tags}
\title{Retrieve tags associated with an object}
\usage{
tags(obj, envir = parent.frame())
}
\arguments{
\item{obj}{The object to retrieve tags from.}

\item{envir}{The environment in which the object exists. Defaults to the parent environment.}
}
\value{
Returns a sorted vector of tags associated with the object. If the object has no tags, the function prints a message and returns NULL.
}
\description{
This function retrieves the tags associated with a specified object.
}
\examples{
# create a variable
x <- 5

# add tags to the variable
add_tags(x, "important", "numeric")

# retrieve the tags
tags(x)

}
