% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption.R
\name{absorption}
\alias{absorption}
\title{Calculates the absorption coefficient for sound in seawater}
\usage{
absorption(freq, temperature, d)
}
\arguments{
\item{freq}{frequency in Hz}

\item{temperature}{temperature in degrees C}

\item{d}{depth in meters}
}
\value{
The sound absorption in dB per metre.
}
\description{
Calculates the absorption coefficient for sound in seawater
}
\note{
Input arguments can be scalars, or a mixture of vectors and scalars as long as each argument is either a vector of length nx1 (with n being the same for all vector arguments) or a scalar.

After Kinsler and Frey pp. 159-160
}
\examples{
absorption(140e3, 13, 10)
}
