% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsf.R
\name{dsf}
\alias{dsf}
\title{Estimate the dominant stroke frequency}
\usage{
dsf(A, sampling_rate = NULL, fc = NULL, Nfft = NULL)
}
\arguments{
\item{A}{A sensor data list or an nx3 acceleration matrix with columns [ax ay az]. Acceleration can be in any consistent unit, e.g., g or m/s^2.}

\item{sampling_rate}{The sampling rate of the sensor data in Hz (samples per second).}

\item{fc}{(optional) The cut-off frequency in Hz of a low-pass filter to apply to A before computing the spectra. This prevents high frequency transients e.g., in foraging, from dominating the spectra. The filter  length is 6*sampling_rate/fc. If fc is not specified, it defaults to 2.5 Hz. If fc>sampling_rate/2, the filtering operation is skipped.}

\item{Nfft}{(optional) The FFT length and therefore the frequency resolution. The default value is the power of two closest to 20*sampling_rate, i.e., an analysis block length of about 20 s and a frequency resolution of about 0.05 Hz. A shorter FFT may be required if movement behaviour is very variable. A longer FFT may work well if propulsion is continuous and stereotyped.}
}
\value{
A list with 2 elements:
\itemize{
\item{\strong{fpk: }}The dominant stroke frequency (i.e., the peak frequency in the sum of the acceleration power spectra) in Hz. Quadratic interpolation is used over the spectral peak to improve resolution.
\item{\strong{q: }} The quality of the peak measured by the peak power divided by the mean power of the spectra. This is a dimensionless number which is large if there is a clear spectral peak.
}
}
\description{
This function can be used to estimate the dominant stroke frequency from triaxial accelerometer data [ax,ay,az].
}
\details{
Animals tend to produce propulsive movements with a narrow frequency range. These movements cause cyclical changes in posture and/or specific acceleration, both of which are measured by an animal-attached accelerometer. Thus sections of accelerometer data that largely contain propulsion should show a spectral peak in one or more axes at the dominant stroke frequency.
}
\note{
Frame: This function makes no assumption about accelerometer frame. Data in any frame can be used.

Data selection: This function works best if the sensor matrix, A, covers an interval in which propulsion is the main activity. This could be a complete dive or an interval of running or flapping flight. The interval length should be at least Nfft/sampling_rate seconds, i.e., 20 s for the default FFT length.
}
\examples{
dsf(harbor_seal$A)

}
