# tangram a general purpose table toolkit for R
# Copyright (C) 2017 Shawn Garbett
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Since this supports a subset of Rmarkdown, the special characters #$*\^_`~ must be
# escaped to be captured by this translation table.
gsub_table <- list(
  # Brace conversion happens first!
  c("\u007B",     "\\\\lbrace"),
  c("\u007D",     "\\\\rbrace{}"),
  c("\\\\lbrace", "\\\\lbrace{}"),

  # Space Conversions
  c("\u000a\u000a", "\\\\vspace{5mm}"),             # 2 Newlines   -> vspace
  c("\u000d\u000a\u000d\u000a", "\\\\vspace{5mm}"), # 2 CR/Newline -> vspace

  # Mostly orderly UNICODE Conversions
  c("\\\\\u0023", "\\\\#"),
  c("\\\\\\\u0024", "\\\\textdollar{}"),
  c("\u0025", "\\\\%"),
  c("\u0026", "\\\\&"),
  c("\u0027", "\\\\textquotesingle{}"),
  c("\\\\\\\u002A", "\\\\ast{}"), # The escape is deep with this one
  c("\u003C", "\\\\textless{}"),
  c("\u003E", "\\\\textgreater{}"),
# Defered till all escaped characters are handled
#  c("\\\u005C", "\\\\textbackslash{}"),
  c("\\\\\\\u005E", "\\\\textasciicircum{}"),
  c("\\\\\\\u005F", "\\\\_"),
  c("\\\\\\\u0060", "\\\\textasciigrave{}"),
  c("\\\u007C", "\\\\vert{}"),
  c("\\\\\\\u007E", "\\\\textasciitilde{}"),
# NBSP handled below special handling
#  c("\u00A0",                 "~"),
  c("\u00A1", "\\\\textexclamdown{}"),
  c("\u00A2", "\\\\textcent{}"),
  c("\u00A3", "\\\\textsterling{}"),
  c("\u00A4", "\\\\textcurrency{}"),
  c("\u00A5", "\\\\textyen{}"),
  c("\u00A6", "\\\\textbrokenbar{}"),
  c("\u00A7", "\\\\textsection{}"),
  c("\u00A8", "\\\\textasciidieresis{}"),
  c("\u00A9", "\\\\textcopyright{}"),
  c("\u00AA", "\\\\textordfeminine{}"),
  c("\u00AB", "\\\\guillemotleft{}"),
  c("\u00AC", "\\\\lnot{}"),
  c("\u00AD", "\\\\-"),
  c("\u00AE", "\\\\textregistered{}"),
  c("\u00AF", "\\\\textasciimacron{}"),
  c("\u00B0", "\\\\textdegree{}"),
  c("\u00B1", "\\\\pm{}"),
  c("\u00B2", "{^2}"),
  c("\u00B3", "{^3}"),
  c("\u00B4", "\\\\textasciiacute{}"),
  c("\u00B5", "\\\\mathrm{\\\\mu}"),
  c("\u00B6", "\\\\textparagraph{}"),
  c("\u00B7", "\\\\cdot{}"),
  c("\u00B8", "\\\\c{}"),
  c("\u00B9", "{^1}"),
  c("\u00BA", "\\\\textordmasculine{}"),
  c("\u00BB", "\\\\guillemotright{}"),
  c("\u00BC", "\\\\textonequarter{}"),
  c("\u00BD", "\\\\textonehalf{}"),
  c("\u00BE", "\\\\textthreequarters{}"),
  c("\u00BF", "\\\\textquestiondown{}"),
  c("\u00C0", "\\\\`{A}"),
  c("\u00C1", "\\\\'{A}"),
  c("\u00C2", "\\\\^{A}"),
  c("\u00C3", "\\\\~{A}"),
  c("\u00C4", "\\\\\"{A}"),
  c("\u00C5", "\\\\AA{}"),
  c("\u00C6", "\\\\AE{}"),
  c("\u00C7", "\\\\c{C}"),
  c("\u00C8", "\\\\`{E}"),
  c("\u00C9", "\\\\'{E}"),
  c("\u00CA", "\\\\^{E}"),
  c("\u00CB", "\\\\\"{E}"),
  c("\u00CC", "\\\\`{I}"),
  c("\u00CD", "\\\\'{I}"),
  c("\u00CE", "\\\\^{I}"),
  c("\u00CF", "\\\\\"{I}"),
  c("\u00D0", "\\\\DH{}"),
  c("\u00D1", "\\\\~{N}"),
  c("\u00D2", "\\\\`{O}"),
  c("\u00D3", "\\\\'{O}"),
  c("\u00D4", "\\\\^{O}"),
  c("\u00D5", "\\\\~{O}"),
  c("\u00D6", "\\\\\"{O}"),
  c("\u00D7", "\\\\texttimes{}"),
  c("\u00D8", "\\\\O{}"),
  c("\u00D9", "\\\\`{U}"),
  c("\u00DA", "\\\\'{U}"),
  c("\u00DB", "\\\\^{U}"),
  c("\u00DC", "\\\\\"{U}"),
  c("\u00DD", "\\\\'{Y}"),
  c("\u00DE", "\\\\TH{}"),
  c("\u00DF", "\\\\ss{}"),
  c("\u00E0", "\\\\`{a}"),
  c("\u00E1", "\\\\'{a}"),
  c("\u00E2", "\\\\^{a}"),
  c("\u00E3", "\\\\~{a}"),
  c("\u00E4", "\\\\\"{a}"),
  c("\u00E5", "\\\\aa{}"),
  c("\u00E6", "\\\\ae{}"),
  c("\u00E7", "\\\\c{c}"),
  c("\u00E8", "\\\\`{e}"),
  c("\u00E9", "\\\\'{e}"),
  c("\u00EA", "\\\\^{e}"),
  c("\u00EB", "\\\\\"{e}"),
  c("\u00EC", "\\\\`{\\\\i}"),
  c("\u00ED", "\\\\'{\\\\i}"),
  c("\u00EE", "\\\\^{\\\\i}"),
  c("\u00EF", "\\\\\"{\\\\i}"),
  c("\u00F0", "\\\\dh{}"),
  c("\u00F1", "\\\\~{n}"),
  c("\u00F2", "\\\\`{o}"),
  c("\u00F3", "\\\\'{o}"),
  c("\u00F4", "\\\\^{o}"),
  c("\u00F5", "\\\\~{o}"),
  c("\u00F6", "\\\\\"{o}"),
  c("\u00F7", "\\\\div{}"),
  c("\u00F8", "\\\\o{}"),
  c("\u00F9", "\\\\`{u}"),
  c("\u00FA", "\\\\'{u}"),
  c("\u00FB", "\\\\^{u}"),
  c("\u00FC", "\\\\\"{u}"),
  c("\u00FD", "\\\\'{y}"),
  c("\u00FE", "\\\\th{}"),
  c("\u00FF", "\\\\\"{y}"),
  c("\u0100", "\\\\={A}"),
  c("\u0101", "\\\\={a}"),
  c("\u0102", "\\\\u{A}"),
  c("\u0103", "\\\\u{a}"),
  c("\u0104", "\\\\k{A}"),
  c("\u0105", "\\\\k{a}"),
  c("\u0106", "\\\\'{C}"),
  c("\u0107", "\\\\'{c}"),
  c("\u0108", "\\\\^{C}"),
  c("\u0109", "\\\\^{c}"),
  c("\u010A", "\\\\.{C}"),
  c("\u010B", "\\\\.{c}"),
  c("\u010C", "\\\\v{C}"),
  c("\u010D", "\\\\v{c}"),
  c("\u010E", "\\\\v{D}"),
  c("\u010F", "\\\\v{d}"),
  c("\u0110", "\\\\DJ{}"),
  c("\u0111", "\\\\dj{}"),
  c("\u0112", "\\\\={E}"),
  c("\u0113", "\\\\={e}"),
  c("\u0114", "\\\\u{E}"),
  c("\u0115", "\\\\u{e}"),
  c("\u0116", "\\\\.{E}"),
  c("\u0117", "\\\\.{e}"),
  c("\u0118", "\\\\k{E}"),
  c("\u0119", "\\\\k{e}"),
  c("\u011A", "\\\\v{E}"),
  c("\u011B", "\\\\v{e}"),
  c("\u011C", "\\\\^{G}"),
  c("\u011D", "\\\\^{g}"),
  c("\u011E", "\\\\u{G}"),
  c("\u011F", "\\\\u{g}"),
  c("\u0120", "\\\\.{G}"),
  c("\u0121", "\\\\.{g}"),
  c("\u0122", "\\\\c{G}"),
  c("\u0123", "\\\\c{g}"),
  c("\u0124", "\\\\^{H}"),
  c("\u0125", "\\\\^{h}"),
  c("\u0126", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char40}"),
  c("\u0127", "\\\\Elzxh{}"),
  c("\u0128", "\\\\~{I}"),
  c("\u0129", "\\\\~{\\\\i}"),
  c("\u012A", "\\\\={I}"),
  c("\u012B", "\\\\={\\\\i}"),
  c("\u012C", "\\\\u{I}"),
  c("\u012D", "\\\\u{\\\\i}"),
  c("\u012E", "\\\\k{I}"),
  c("\u012F", "\\\\k{i}"),
  c("\u0130", "\\\\.{I}"),
  c("\u0131", "\\\\i{}"),
  c("\u0132", "\\\\IJ{}"),
  c("\u0133", "\\\\ij{}"),
  c("\u0134", "\\\\^{J}"),
  c("\u0135", "\\\\^{\\\\j}"),
  c("\u0136", "\\\\c{K}"),
  c("\u0137", "\\\\c{k}"),
  c("\u0138", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char91}"),
  c("\u0139", "\\\\'{L}"),
  c("\u013A", "\\\\'{l}"),
  c("\u013B", "\\\\c{L}"),
  c("\u013C", "\\\\c{l}"),
  c("\u013D", "\\\\v{L}"),
  c("\u013E", "\\\\v{l}"),
  c("\u013F", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char201}"),
  c("\u0140", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char202}"),
  c("\u0141", "\\\\L{}"),
  c("\u0142", "\\\\l{}"),
  c("\u0143", "\\\\'{N}"),
  c("\u0144", "\\\\'{n}"),
  c("\u0145", "\\\\c{N}"),
  c("\u0146", "\\\\c{n}"),
  c("\u0147", "\\\\v{N}"),
  c("\u0148", "\\\\v{n}"),
  c("\u0149", "'n"),
  c("\u014A", "\\\\NG{}"),
  c("\u014B", "\\\\ng{}"),
  c("\u014C", "\\\\={O}"),
  c("\u014D", "\\\\={o}"),
  c("\u014E", "\\\\u{O}"),
  c("\u014F", "\\\\u{o}"),
  c("\u0150", "\\\\H{O}"),
  c("\u0151", "\\\\H{o}"),
  c("\u0152", "\\\\OE{}"),
  c("\u0153", "\\\\oe{}"),
  c("\u0154", "\\\\'{R}"),
  c("\u0155", "\\\\'{r}"),
  c("\u0156", "\\\\c{R}"),
  c("\u0157", "\\\\c{r}"),
  c("\u0158", "\\\\v{R}"),
  c("\u0159", "\\\\v{r}"),
  c("\u015A", "\\\\'{S}"),
  c("\u015B", "\\\\'{s}"),
  c("\u015C", "\\\\^{S}"),
  c("\u015D", "\\\\^{s}"),
  c("\u015E", "\\\\c{S}"),
  c("\u015F", "\\\\c{s}"),
  c("\u0160", "\\\\v{S}"),
  c("\u0161", "\\\\v{s}"),
  c("\u0162", "\\\\c{T}"),
  c("\u0163", "\\\\c{t}"),
  c("\u0164", "\\\\v{T}"),
  c("\u0165", "\\\\v{t}"),
  c("\u0166", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char47}"),
  c("\u0167", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char63}"),
  c("\u0168", "\\\\~{U}"),
  c("\u0169", "\\\\~{u}"),
  c("\u016A", "\\\\={U}"),
  c("\u016B", "\\\\={u}"),
  c("\u016C", "\\\\u{U}"),
  c("\u016D", "\\\\u{u}"),
  c("\u016E", "\\\\r{U}"),
  c("\u016F", "\\\\r{u}"),
  c("\u0170", "\\\\H{U}"),
  c("\u0171", "\\\\H{u}"),
  c("\u0172", "\\\\k{U}"),
  c("\u0173", "\\\\k{u}"),
  c("\u0174", "\\\\^{W}"),
  c("\u0175", "\\\\^{w}"),
  c("\u0176", "\\\\^{Y}"),
  c("\u0177", "\\\\^{y}"),
  c("\u0178", "\\\\\"{Y}"),
  c("\u0179", "\\\\'{Z}"),
  c("\u017A", "\\\\'{z}"),
  c("\u017B", "\\\\.{Z}"),
  c("\u017C", "\\\\.{z}"),
  c("\u017D", "\\\\v{Z}"),
  c("\u017E", "\\\\v{z}"),
  c("\u017F", "\\\\ifdefined\\\\XeTeXrevision\\\\symbol{\"017F}\\\\else\\\\ifdefined\\\\directlua\\\\symbol{\"017F}\\\\else{\\\\fontencoding{TS1}\\\\selectfont s}\\\\fi\\\\fi{}"),
  c("\u0195", "\\\\texthvlig{}"),
  c("\u019E", "\\\\textnrleg{}"),
  c("\u01AA", "\\\\eth{}"),
  c("\u01BA", "{\\\\fontencoding{LELA}\\\\selectfont\\\\char195}"),
  c("\u01C2", "\\\\textdoublepipe{}"),
  c("\u01c4", "DZ\u030c"),
  c("\u01c5", "Dz\u030c"),
  c("\u01c6", "dz\u030c"),
  c("\u01c7", "LJ"),
  c("\u01c8", "Lj"),
  c("\u01c9", "lj"),
  c("\u01ca", "NJ"),
  c("\u01cb", "Nj"),
  c("\u01cc", "nj"),
  c("\u01F1", "DZ"),
  c("\u01F2", "Dz"),
  c("\u01F3", "dz"),
  c("\u01F5", "\\\\'{g}"),
  c("\u0250", "\\\\Elztrna{}"),
  c("\u0252", "\\\\Elztrnsa{}"),
  c("\u0254", "\\\\Elzopeno{}"),
  c("\u0256", "\\\\Elzrtld{}"),
  c("\u0258", "{\\\\fontencoding{LEIP}\\\\selectfont\\\\char61}"),
  c("\u0259", "\\\\Elzschwa{}"),
  c("\u025B", "\\\\varepsilon{}"),
  c("\u0263", "\\\\Elzpgamma{}"),
  c("\u0264", "\\\\Elzpbgam{}"),
  c("\u0265", "\\\\Elztrnh{}"),
  c("\u026C", "\\\\Elzbtdl{}"),
  c("\u026D", "\\\\Elzrtll{}"),
  c("\u026F", "\\\\Elztrnm{}"),
  c("\u0270", "\\\\Elztrnmlr{}"),
  c("\u0271", "\\\\Elzltlmr{}"),
  c("\u0272", "\\\\Elzltln{}"),
  c("\u0273", "\\\\Elzrtln{}"),
  c("\u0277", "\\\\Elzclomeg{}"),
  c("\u0278", "\\\\textphi{}"),
  c("\u0279", "\\\\Elztrnr{}"),
  c("\u027A", "\\\\Elztrnrl{}"),
  c("\u027B", "\\\\Elzrttrnr{}"),
  c("\u027C", "\\\\Elzrl{}"),
  c("\u027D", "\\\\Elzrtlr{}"),
  c("\u027E", "\\\\Elzfhr{}"),
  c("\u027F", "{\\\\fontencoding{LEIP}\\\\selectfont\\\\char202}"),
  c("\u0282", "\\\\Elzrtls{}"),
  c("\u0283", "\\\\Elzesh{}"),
  c("\u0287", "\\\\Elztrnt{}"),
  c("\u0288", "\\\\Elzrtlt{}"),
  c("\u028A", "\\\\Elzpupsil{}"),
  c("\u028B", "\\\\Elzpscrv{}"),
  c("\u028C", "\\\\Elzinvv{}"),
  c("\u028D", "\\\\Elzinvw{}"),
  c("\u028E", "\\\\Elztrny{}"),
  c("\u0290", "\\\\Elzrtlz{}"),
  c("\u0292", "\\\\Elzyogh{}"),
  c("\u0294", "\\\\Elzglst{}"),
  c("\u0295", "\\\\Elzreglst{}"),
  c("\u0296", "\\\\Elzinglst{}"),
  c("\u029E", "\\\\textturnk{}"),
  c("\u02A4", "\\\\Elzdyogh{}"),
  c("\u02A7", "\\\\Elztesh{}"),
  c("\u02C7", "\\\\textasciicaron{}"),
  c("\u02C8", "\\\\Elzverts{}"),
  c("\u02CC", "\\\\Elzverti{}"),
  c("\u02D0", "\\\\Elzlmrk{}"),
  c("\u02D1", "\\\\Elzhlmrk{}"),
  c("\u02D2", "\\\\Elzsbrhr{}"),
  c("\u02D3", "\\\\Elzsblhr{}"),
  c("\u02D4", "\\\\Elzrais{}"),
  c("\u02D5", "\\\\Elzlow{}"),
  c("\u02D8", "\\\\textasciibreve{}"),
  c("\u02D9", "\\\\textperiodcentered{}"),
  c("\u02DA", "\\\\r{}"),
  c("\u02DB", "\\\\k{}"),
  c("\u02DC", "\\\\texttildelow{}"),
  c("\u02DD", "\\\\textacutedbl{}"),
  c("\u02E5", "\\\\tone{55}"),
  c("\u02E6", "\\\\tone{44}"),
  c("\u02E7", "\\\\tone{33}"),
  c("\u02E8", "\\\\tone{22}"),
  c("\u02E9", "\\\\tone{11}"),
  c("\u02F7", "\\\\texttildelow{}"),
  c("\u0300", "\\\\`"),
  c("\u0301", "\\\\'"),
  c("\u0302", "\\\\^"),
  c("\u0303", "\\\\~"),
  c("\u0304", "\\\\="),
  c("\u0306", "\\\\u"),
  c("\u0307", "\\\\."),
  c("\u0308", "\\\\\""),
  c("\u030A", "\\\\r"),
  c("\u030B", "\\\\H"),
  c("\u030C", "\\\\v"),
  c("\u030F", "\\\\cyrchar\\\\C"),
  c("\u0311", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char177}"),
  c("\u0318", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char184}"),
  c("\u0319", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char185}"),
  c("\u0321", "\\\\Elzpalh{}"),
  c("\u0322", "\\\\Elzrh{}"),
  c("\u0327", "\\\\c"),
  c("\u0328", "\\\\k"),
  c("\u032A", "\\\\Elzsbbrg{}"),
  c("\u032B", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char203}"),
  c("\u032F", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char207}"),
  c("\u0335", "\\\\Elzxl{}"),
  c("\u0336", "\\\\Elzbar{}"),
  c("\u0337", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char215}"),
  c("\u0338", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char216}"),
  c("\u033A", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char218}"),
  c("\u033B", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char219}"),
  c("\u033C", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char220}"),
  c("\u033D", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char221}"),
  c("\u0361", "{\\\\fontencoding{LECO}\\\\selectfont\\\\char225}"),
  c("\u0386", "\\\\'{A}"),
  c("\u0388", "\\\\'{E}"),
  c("\u0389", "\\\\'{H}"),
  c("\u038A", "\\\\'{}{I}"),
  c("\u038C", "\\\\'{}O"),
  c("\u038E", "\\\\mathrm{'Y}"),
  c("\u038F", "\\\\mathrm{'\\\\Omega}"),
  c("\u0390", "\\\\acute{\\\\ddot{\\\\iota}}"),
  c("\u0391", "\\\\Alpha{}"),
  c("\u0392", "\\\\Beta{}"),
  c("\u0393", "\\\\Gamma{}"),
  c("\u0394", "\\\\Delta{}"),
  c("\u0395", "\\\\Epsilon{}"),
  c("\u0396", "\\\\Zeta{}"),
  c("\u0397", "\\\\Eta{}"),
  c("\u0398", "\\\\Theta{}"),
  c("\u0399", "\\\\Iota{}"),
  c("\u039A", "\\\\Kappa{}"),
  c("\u039B", "\\\\Lambda{}"),
  c("\u039E", "\\\\Xi{}"),
  c("\u03A0", "\\\\Pi{}"),
  c("\u03A1", "\\\\Rho{}"),
  c("\u03A3", "\\\\Sigma{}"),
  c("\u03A4", "\\\\Tau{}"),
  c("\u03A5", "\\\\Upsilon{}"),
  c("\u03A6", "\\\\Phi{}"),
  c("\u03A7", "\\\\Chi{}"),
  c("\u03A8", "\\\\Psi{}"),
  c("\u03A9", "\\\\Omega{}"),
  c("\u03AA", "\\\\mathrm{\\\\ddot{I}}"),
  c("\u03AB", "\\\\mathrm{\\\\ddot{Y}}"),
  c("\u03AC", "\\\\'{$\\\\alpha$}"),
  c("\u03AD", "\\\\acute{\\\\epsilon}"),
  c("\u03AE", "\\\\acute{\\\\eta}"),
  c("\u03AF", "\\\\acute{\\\\iota}"),
  c("\u03B0", "\\\\acute{\\\\ddot{\\\\upsilon}}"),
  c("\u03B1", "\\\\alpha{}"),
  c("\u03B2", "\\\\beta{}"),
  c("\u03B3", "\\\\gamma{}"),
  c("\u03B4", "\\\\delta{}"),
  c("\u03B5", "\\\\epsilon{}"),
  c("\u03B6", "\\\\zeta{}"),
  c("\u03B7", "\\\\eta{}"),
  c("\u03B8", "\\\\texttheta{}"),
  c("\u03B9", "\\\\iota{}"),
  c("\u03BA", "\\\\kappa{}"),
  c("\u03BB", "\\\\lambda{}"),
  c("\u03BC", "\\\\mu{}"),
  c("\u03BD", "\\\\nu{}"),
  c("\u03BE", "\\\\xi{}"),
  c("\u03C0", "\\\\pi{}"),
  c("\u03C1", "\\\\rho{}"),
  c("\u03C2", "\\\\varsigma{}"),
  c("\u03C3", "\\\\sigma{}"),
  c("\u03C4", "\\\\tau{}"),
  c("\u03C5", "\\\\upsilon{}"),
  c("\u03C6", "\\\\varphi{}"),
  c("\u03C7", "\\\\chi{}"),
  c("\u03C8", "\\\\psi{}"),
  c("\u03C9", "\\\\omega{}"),
  c("\u03CA", "\\\\ddot{\\\\iota}"),
  c("\u03CB", "\\\\ddot{\\\\upsilon}"),
  c("\u03CC", "\\\\'{o}"),
  c("\u03CD", "\\\\acute{\\\\upsilon}"),
  c("\u03CE", "\\\\acute{\\\\omega}"),
  c("\u03D0", "\\\\Pisymbol{ppi022}{87}"),
  c("\u03D1", "\\\\textvartheta{}"),
  c("\u03D2", "\\\\Upsilon{}"),
  c("\u03D5", "\\\\phi{}"),
  c("\u03D6", "\\\\varpi{}"),
  c("\u03DA", "\\\\Stigma{}"),
  c("\u03DC", "\\\\Digamma{}"),
  c("\u03DD", "\\\\digamma{}"),
  c("\u03DE", "\\\\Koppa{}"),
  c("\u03E0", "\\\\Sampi{}"),
  c("\u03F0", "\\\\varkappa{}"),
  c("\u03F1", "\\\\varrho{}"),
  c("\u03F4", "\\\\textTheta{}"),
  c("\u03F6", "\\\\backepsilon{}"),
  c("\u0401", "\\\\cyrchar\\\\CYRYO{}"),
  c("\u0402", "\\\\cyrchar\\\\CYRDJE{}"),
  c("\u0403", "\\\\cyrchar{\\\\'\\\\CYRG}"),
  c("\u0404", "\\\\cyrchar\\\\CYRIE{}"),
  c("\u0405", "\\\\cyrchar\\\\CYRDZE{}"),
  c("\u0406", "\\\\cyrchar\\\\CYRII{}"),
  c("\u0407", "\\\\cyrchar\\\\CYRYI{}"),
  c("\u0408", "\\\\cyrchar\\\\CYRJE{}"),
  c("\u0409", "\\\\cyrchar\\\\CYRLJE{}"),
  c("\u040A", "\\\\cyrchar\\\\CYRNJE{}"),
  c("\u040B", "\\\\cyrchar\\\\CYRTSHE{}"),
  c("\u040C", "\\\\cyrchar{\\\\'\\\\CYRK}"),
  c("\u040E", "\\\\cyrchar\\\\CYRUSHRT{}"),
  c("\u040F", "\\\\cyrchar\\\\CYRDZHE{}"),
  c("\u0410", "\\\\cyrchar\\\\CYRA{}"),
  c("\u0411", "\\\\cyrchar\\\\CYRB{}"),
  c("\u0412", "\\\\cyrchar\\\\CYRV{}"),
  c("\u0413", "\\\\cyrchar\\\\CYRG{}"),
  c("\u0414", "\\\\cyrchar\\\\CYRD{}"),
  c("\u0415", "\\\\cyrchar\\\\CYRE{}"),
  c("\u0416", "\\\\cyrchar\\\\CYRZH{}"),
  c("\u0417", "\\\\cyrchar\\\\CYRZ{}"),
  c("\u0418", "\\\\cyrchar\\\\CYRI{}"),
  c("\u0419", "\\\\cyrchar\\\\CYRISHRT{}"),
  c("\u041A", "\\\\cyrchar\\\\CYRK{}"),
  c("\u041B", "\\\\cyrchar\\\\CYRL{}"),
  c("\u041C", "\\\\cyrchar\\\\CYRM{}"),
  c("\u041D", "\\\\cyrchar\\\\CYRN{}"),
  c("\u041E", "\\\\cyrchar\\\\CYRO{}"),
  c("\u041F", "\\\\cyrchar\\\\CYRP{}"),
  c("\u0420", "\\\\cyrchar\\\\CYRR{}"),
  c("\u0421", "\\\\cyrchar\\\\CYRS{}"),
  c("\u0422", "\\\\cyrchar\\\\CYRT{}"),
  c("\u0423", "\\\\cyrchar\\\\CYRU{}"),
  c("\u0424", "\\\\cyrchar\\\\CYRF{}"),
  c("\u0425", "\\\\cyrchar\\\\CYRH{}"),
  c("\u0426", "\\\\cyrchar\\\\CYRC{}"),
  c("\u0427", "\\\\cyrchar\\\\CYRCH{}"),
  c("\u0428", "\\\\cyrchar\\\\CYRSH{}"),
  c("\u0429", "\\\\cyrchar\\\\CYRSHCH{}"),
  c("\u042A", "\\\\cyrchar\\\\CYRHRDSN{}"),
  c("\u042B", "\\\\cyrchar\\\\CYRERY{}"),
  c("\u042C", "\\\\cyrchar\\\\CYRSFTSN{}"),
  c("\u042D", "\\\\cyrchar\\\\CYREREV{}"),
  c("\u042E", "\\\\cyrchar\\\\CYRYU{}"),
  c("\u042F", "\\\\cyrchar\\\\CYRYA{}"),
  c("\u0430", "\\\\cyrchar\\\\cyra{}"),
  c("\u0431", "\\\\cyrchar\\\\cyrb{}"),
  c("\u0432", "\\\\cyrchar\\\\cyrv{}"),
  c("\u0433", "\\\\cyrchar\\\\cyrg{}"),
  c("\u0434", "\\\\cyrchar\\\\cyrd{}"),
  c("\u0435", "\\\\cyrchar\\\\cyre{}"),
  c("\u0436", "\\\\cyrchar\\\\cyrzh{}"),
  c("\u0437", "\\\\cyrchar\\\\cyrz{}"),
  c("\u0438", "\\\\cyrchar\\\\cyri{}"),
  c("\u0439", "\\\\cyrchar\\\\cyrishrt{}"),
  c("\u043A", "\\\\cyrchar\\\\cyrk{}"),
  c("\u043B", "\\\\cyrchar\\\\cyrl{}"),
  c("\u043C", "\\\\cyrchar\\\\cyrm{}"),
  c("\u043D", "\\\\cyrchar\\\\cyrn{}"),
  c("\u043E", "\\\\cyrchar\\\\cyro{}"),
  c("\u043F", "\\\\cyrchar\\\\cyrp{}"),
  c("\u0440", "\\\\cyrchar\\\\cyrr{}"),
  c("\u0441", "\\\\cyrchar\\\\cyrs{}"),
  c("\u0442", "\\\\cyrchar\\\\cyrt{}"),
  c("\u0443", "\\\\cyrchar\\\\cyru{}"),
  c("\u0444", "\\\\cyrchar\\\\cyrf{}"),
  c("\u0445", "\\\\cyrchar\\\\cyrh{}"),
  c("\u0446", "\\\\cyrchar\\\\cyrc{}"),
  c("\u0447", "\\\\cyrchar\\\\cyrch{}"),
  c("\u0448", "\\\\cyrchar\\\\cyrsh{}"),
  c("\u0449", "\\\\cyrchar\\\\cyrshch{}"),
  c("\u044A", "\\\\cyrchar\\\\cyrhrdsn{}"),
  c("\u044B", "\\\\cyrchar\\\\cyrery{}"),
  c("\u044C", "\\\\cyrchar\\\\cyrsftsn{}"),
  c("\u044D", "\\\\cyrchar\\\\cyrerev{}"),
  c("\u044E", "\\\\cyrchar\\\\cyryu{}"),
  c("\u044F", "\\\\cyrchar\\\\cyrya{}"),
  c("\u0451", "\\\\cyrchar\\\\cyryo{}"),
  c("\u0452", "\\\\cyrchar\\\\cyrdje{}"),
  c("\u0453", "\\\\cyrchar{\\\\'\\\\cyrg}"),
  c("\u0454", "\\\\cyrchar\\\\cyrie{}"),
  c("\u0455", "\\\\cyrchar\\\\cyrdze{}"),
  c("\u0456", "\\\\cyrchar\\\\cyrii{}"),
  c("\u0457", "\\\\cyrchar\\\\cyryi{}"),
  c("\u0458", "\\\\cyrchar\\\\cyrje{}"),
  c("\u0459", "\\\\cyrchar\\\\cyrlje{}"),
  c("\u045A", "\\\\cyrchar\\\\cyrnje{}"),
  c("\u045B", "\\\\cyrchar\\\\cyrtshe{}"),
  c("\u045C", "\\\\cyrchar{\\\\'\\\\cyrk}"),
  c("\u045E", "\\\\cyrchar\\\\cyrushrt{}"),
  c("\u045F", "\\\\cyrchar\\\\cyrdzhe{}"),
  c("\u0460", "\\\\cyrchar\\\\CYROMEGA{}"),
  c("\u0461", "\\\\cyrchar\\\\cyromega{}"),
  c("\u0462", "\\\\cyrchar\\\\CYRYAT{}"),
  c("\u0464", "\\\\cyrchar\\\\CYRIOTE{}"),
  c("\u0465", "\\\\cyrchar\\\\cyriote{}"),
  c("\u0466", "\\\\cyrchar\\\\CYRLYUS{}"),
  c("\u0467", "\\\\cyrchar\\\\cyrlyus{}"),
  c("\u0468", "\\\\cyrchar\\\\CYRIOTLYUS{}"),
  c("\u0469", "\\\\cyrchar\\\\cyriotlyus{}"),
  c("\u046A", "\\\\cyrchar\\\\CYRBYUS{}"),
  c("\u046C", "\\\\cyrchar\\\\CYRIOTBYUS{}"),
  c("\u046D", "\\\\cyrchar\\\\cyriotbyus{}"),
  c("\u046E", "\\\\cyrchar\\\\CYRKSI{}"),
  c("\u046F", "\\\\cyrchar\\\\cyrksi{}"),
  c("\u0470", "\\\\cyrchar\\\\CYRPSI{}"),
  c("\u0471", "\\\\cyrchar\\\\cyrpsi{}"),
  c("\u0472", "\\\\cyrchar\\\\CYRFITA{}"),
  c("\u0474", "\\\\cyrchar\\\\CYRIZH{}"),
  c("\u0478", "\\\\cyrchar\\\\CYRUK{}"),
  c("\u0479", "\\\\cyrchar\\\\cyruk{}"),
  c("\u047A", "\\\\cyrchar\\\\CYROMEGARND{}"),
  c("\u047B", "\\\\cyrchar\\\\cyromegarnd{}"),
  c("\u047C", "\\\\cyrchar\\\\CYROMEGATITLO{}"),
  c("\u047D", "\\\\cyrchar\\\\cyromegatitlo{}"),
  c("\u047E", "\\\\cyrchar\\\\CYROT{}"),
  c("\u047F", "\\\\cyrchar\\\\cyrot{}"),
  c("\u0480", "\\\\cyrchar\\\\CYRKOPPA{}"),
  c("\u0481", "\\\\cyrchar\\\\cyrkoppa{}"),
  c("\u0482", "\\\\cyrchar\\\\cyrthousands{}"),
  c("\u0488", "\\\\cyrchar\\\\cyrhundredthousands{}"),
  c("\u0489", "\\\\cyrchar\\\\cyrmillions{}"),
  c("\u048C", "\\\\cyrchar\\\\CYRSEMISFTSN{}"),
  c("\u048D", "\\\\cyrchar\\\\cyrsemisftsn{}"),
  c("\u048E", "\\\\cyrchar\\\\CYRRTICK{}"),
  c("\u048F", "\\\\cyrchar\\\\cyrrtick{}"),
  c("\u0490", "\\\\cyrchar\\\\CYRGUP{}"),
  c("\u0491", "\\\\cyrchar\\\\cyrgup{}"),
  c("\u0492", "\\\\cyrchar\\\\CYRGHCRS{}"),
  c("\u0493", "\\\\cyrchar\\\\cyrghcrs{}"),
  c("\u0494", "\\\\cyrchar\\\\CYRGHK{}"),
  c("\u0495", "\\\\cyrchar\\\\cyrghk{}"),
  c("\u0496", "\\\\cyrchar\\\\CYRZHDSC{}"),
  c("\u0497", "\\\\cyrchar\\\\cyrzhdsc{}"),
  c("\u0498", "\\\\cyrchar\\\\CYRZDSC{}"),
  c("\u0499", "\\\\cyrchar\\\\cyrzdsc{}"),
  c("\u049A", "\\\\cyrchar\\\\CYRKDSC{}"),
  c("\u049B", "\\\\cyrchar\\\\cyrkdsc{}"),
  c("\u049C", "\\\\cyrchar\\\\CYRKVCRS{}"),
  c("\u049D", "\\\\cyrchar\\\\cyrkvcrs{}"),
  c("\u049E", "\\\\cyrchar\\\\CYRKHCRS{}"),
  c("\u049F", "\\\\cyrchar\\\\cyrkhcrs{}"),
  c("\u04A0", "\\\\cyrchar\\\\CYRKBEAK{}"),
  c("\u04A1", "\\\\cyrchar\\\\cyrkbeak{}"),
  c("\u04A2", "\\\\cyrchar\\\\CYRNDSC{}"),
  c("\u04A3", "\\\\cyrchar\\\\cyrndsc{}"),
  c("\u04A4", "\\\\cyrchar\\\\CYRNG{}"),
  c("\u04A5", "\\\\cyrchar\\\\cyrng{}"),
  c("\u04A6", "\\\\cyrchar\\\\CYRPHK{}"),
  c("\u04A7", "\\\\cyrchar\\\\cyrphk{}"),
  c("\u04A8", "\\\\cyrchar\\\\CYRABHHA{}"),
  c("\u04A9", "\\\\cyrchar\\\\cyrabhha{}"),
  c("\u04AA", "\\\\cyrchar\\\\CYRSDSC{}"),
  c("\u04AB", "\\\\cyrchar\\\\cyrsdsc{}"),
  c("\u04AC", "\\\\cyrchar\\\\CYRTDSC{}"),
  c("\u04AD", "\\\\cyrchar\\\\cyrtdsc{}"),
  c("\u04AE", "\\\\cyrchar\\\\CYRY{}"),
  c("\u04AF", "\\\\cyrchar\\\\cyry{}"),
  c("\u04B0", "\\\\cyrchar\\\\CYRYHCRS{}"),
  c("\u04B1", "\\\\cyrchar\\\\cyryhcrs{}"),
  c("\u04B2", "\\\\cyrchar\\\\CYRHDSC{}"),
  c("\u04B3", "\\\\cyrchar\\\\cyrhdsc{}"),
  c("\u04B4", "\\\\cyrchar\\\\CYRTETSE{}"),
  c("\u04B5", "\\\\cyrchar\\\\cyrtetse{}"),
  c("\u04B6", "\\\\cyrchar\\\\CYRCHRDSC{}"),
  c("\u04B7", "\\\\cyrchar\\\\cyrchrdsc{}"),
  c("\u04B8", "\\\\cyrchar\\\\CYRCHVCRS{}"),
  c("\u04B9", "\\\\cyrchar\\\\cyrchvcrs{}"),
  c("\u04BA", "\\\\cyrchar\\\\CYRSHHA{}"),
  c("\u04BB", "\\\\cyrchar\\\\cyrshha{}"),
  c("\u04BC", "\\\\cyrchar\\\\CYRABHCH{}"),
  c("\u04BD", "\\\\cyrchar\\\\cyrabhch{}"),
  c("\u04BE", "\\\\cyrchar\\\\CYRABHCHDSC{}"),
  c("\u04BF", "\\\\cyrchar\\\\cyrabhchdsc{}"),
  c("\u04C0", "\\\\cyrchar\\\\CYRpalochka{}"),
  c("\u04C3", "\\\\cyrchar\\\\CYRKHK{}"),
  c("\u04C4", "\\\\cyrchar\\\\cyrkhk{}"),
  c("\u04C7", "\\\\cyrchar\\\\CYRNHK{}"),
  c("\u04C8", "\\\\cyrchar\\\\cyrnhk{}"),
  c("\u04CB", "\\\\cyrchar\\\\CYRCHLDSC{}"),
  c("\u04CC", "\\\\cyrchar\\\\cyrchldsc{}"),
  c("\u04D4", "\\\\cyrchar\\\\CYRAE{}"),
  c("\u04D5", "\\\\cyrchar\\\\cyrae{}"),
  c("\u04D8", "\\\\cyrchar\\\\CYRSCHWA{}"),
  c("\u04D9", "\\\\cyrchar\\\\cyrschwa{}"),
  c("\u04E0", "\\\\cyrchar\\\\CYRABHDZE{}"),
  c("\u04E1", "\\\\cyrchar\\\\cyrabhdze{}"),
  c("\u04E8", "\\\\cyrchar\\\\CYROTLD{}"),
  c("\u04E9", "\\\\cyrchar\\\\cyrotld{}"),
  c("\u0E3F", "\\\\textbaht{}"),
  c("\u1e9e", "\\\\ifdefined\\\\XeTeXrevision\\\\iffontchar\\\\font\"1E9E\\\\symbol{\"1E9E}\\\\else\\\\SS\\\\fi\\\\else\\\\ifdefined\\\\directlua\\\\iffontchar\\\\font\"1E9E\\\\symbol{\"1E9E}\\\\else\\\\SS\\\\fi\\\\else\\\\SS\\\\fi\\\\fi{}"),
  c("\u2002", "\\\\hspace{0.6em}"),
  c("\u2003", "\\\\hspace{1em}"),
  c("\u2004", "\\\\hspace{0.33em}"),
  c("\u2005", "\\\\hspace{0.25em}"),
  c("\u2006", "\\\\hspace{0.166em}"),
  c("\u2007", "\\\\hphantom{0}"),
  c("\u2008", "\\\\hphantom{,}"),
  c("\u2009", "\\\\hspace{0.167em}"),
  c("\u2009-0200A-0200A", "\\\\;"),
  c("\u200A", "\\\\mkern1mu{}"),
  c("\u200B", "\\\\hspace{0pt}"),# zero width space (ZWSP)
  c("\u2013", "\\\\textendash{}"),
  c("\u2014", "\\\\textemdash{}"),
  c("\u2015", "\\\\rule{1em}{1pt}"),
  c("\u2016", "\\\\textbardbl{}"),
  c("\u2018", "\\\\textquoteleft{}"),
  c("\u2019", "\\\\textquoteright{}"),
  c("\u201A", "\\\\quotesinglbase{}"),
  c("\u201B", "\\\\Elzreapos{}"),
  c("\u201C", "\\\\textquotedblleft{}"),
  c("\u201D", "\\\\textquotedblright{}"),
  c("\u201E", "\\\\quotedblbase{}"),
  c("\u2020", "\\\\textdagger{}"),
  c("\u2021", "\\\\textdaggerdbl{}"),
  c("\u2022", "\\\\textbullet{}"),
  c("\u2025", ".."),
  c("\u2026", "\\\\ldots{}"),
  c("\u2030", "\\\\textperthousand{}"),
  c("\u2031", "\\\\textpertenthousand{}"),
  c("\u2032", "{'}"),
  c("\u2033", "{''}"),
  c("\u2034", "{'''}"),
  c("\u2035", "\\\\backprime{}"),
  c("\u2039", "\\\\guilsinglleft{}"),
  c("\u203A", "\\\\guilsinglright{}"),
  c("\u203B", "\\\\textreferencemark{}"),
  c("\u203D", "\\\\textinterrobang{}"),
  c("\u2044", "\\\\textfractionsolidus{}"),
  c("\u2045", "\\\\textlquill{}"),
  c("\u2046", "\\\\textrquill{}"),
  c("\u2052", "\\\\textdiscount{}"),
  c("\u2057", "''''"),
  c("\u205F", "\\\\mkern4mu{}"),
  c("\u2060", "\\\\nolinebreak{}"),
  c("\u20A4", "\\\\textlira{}"),
  c("\u00a5", "\\\\textyen{}"),
  c("\u20A6", "\\\\textnaira{}"),
  c("\u20A7", "\\\\ensuremath{\\\\Elzpes}"),
  c("\u20A9", "\\\\textwon{}"),
  c("\u20AB", "\\\\textdong{}"),
  c("\u20AC", "\\\\mbox{\\\\texteuro}{}"),
  c("\u20B1", "\\\\textpeso{}"),
  c("\u20B2", "\\\\textguarani{}"),
  c("\u20DB", "\\\\dddot{}"),
  c("\u20DC", "\\\\ddddot{}"),
  c("\u2102", "\\\\mathbb{C}"),
  c("\u2103", "\\\\textcelsius{}"),
  c("\u210A", "\\\\mathscr{g}"),
  c("\u210B", "\\\\mathscr{H}"),
  c("\u210C", "\\\\mathfrak{H}"),
  c("\u210D", "\\\\mathbb{H}"),
  c("\u210F", "\\\\hslash{}"),
  c("\u2110", "\\\\mathscr{I}"),
  c("\u2111", "\\\\mathfrak{I}"),
  c("\u2112", "\\\\mathscr{L}"),
  c("\u2113", "\\\\mathscr{l}"),
  c("\u2115", "\\\\mathbb{N}"),
  c("\u2116", "\\\\cyrchar\\\\textnumero{}"),
  c("\u2117", "\\\\textcircledP{}"),
  c("\u2118", "\\\\wp{}"),
  c("\u2119", "\\\\mathbb{P}"),
  c("\u211A", "\\\\mathbb{Q}"),
  c("\u211B", "\\\\mathscr{R}"),
  c("\u211C", "\\\\mathfrak{R}"),
  c("\u211D", "\\\\mathbb{R}"),
  c("\u211E", "\\\\textrecipe{}"),
  c("\u2120", "\\\\textservicemark{}"),
  c("\u2122", "\\\\texttrademark{}"),
  c("\u2124", "\\\\mathbb{Z}"),
  c("\u2126", "\\\\Omega{}"),
  c("\u2127", "\\\\mho{}"),
  c("\u2128", "\\\\mathfrak{Z}"),
  c("\u2129", "\\\\ElsevierGlyph{2129}"),
  c("\u212B", "\\\\AA{}"),
  c("\u212C", "\\\\mathscr{B}"),
  c("\u212D", "\\\\mathfrak{C}"),
  c("\u212E", "\\\\textestimated{}"),
  c("\u212F", "\\\\mathscr{e}"),
  c("\u2130", "\\\\mathscr{E}"),
  c("\u2131", "\\\\mathscr{F}"),
  c("\u2133", "\\\\mathscr{M}"),
  c("\u2134", "\\\\mathscr{o}"),
  c("\u2135", "\\\\aleph{}"),
  c("\u2136", "\\\\beth{}"),
  c("\u2137", "\\\\gimel{}"),
  c("\u2138", "\\\\daleth{}"),
  c("\u2153", "\\\\textfrac{1}{3}"),
  c("\u2154", "\\\\textfrac{2}{3}"),
  c("\u2155", "\\\\textfrac{1}{5}"),
  c("\u2156", "\\\\textfrac{2}{5}"),
  c("\u2157", "\\\\textfrac{3}{5}"),
  c("\u2158", "\\\\textfrac{4}{5}"),
  c("\u2159", "\\\\textfrac{1}{6}"),
  c("\u215A", "\\\\textfrac{5}{6}"),
  c("\u215B", "\\\\textfrac{1}{8}"),
  c("\u215C", "\\\\textfrac{3}{8}"),
  c("\u215D", "\\\\textfrac{5}{8}"),
  c("\u215E", "\\\\textfrac{7}{8}"),
  c("\u2190", "\\\\leftarrow{}"),
  c("\u2191", "\\\\uparrow{}"),
  c("\u2192", "\\\\rightarrow{}"),
  c("\u2193", "\\\\downarrow{}"),
  c("\u2194", "\\\\leftrightarrow{}"),
  c("\u2195", "\\\\updownarrow{}"),
  c("\u2196", "\\\\nwarrow{}"),
  c("\u2197", "\\\\nearrow{}"),
  c("\u2198", "\\\\searrow{}"),
  c("\u2199", "\\\\swarrow{}"),
  c("\u219A", "\\\\nleftarrow{}"),
  c("\u219B", "\\\\nrightarrow{}"),
  c("\u219C", "\\\\arrowwaveright{}"),
  c("\u219D", "\\\\arrowwaveright{}"),
  c("\u219E", "\\\\twoheadleftarrow{}"),
  c("\u21A0", "\\\\twoheadrightarrow{}"),
  c("\u21A2", "\\\\leftarrowtail{}"),
  c("\u21A3", "\\\\rightarrowtail{}"),
  c("\u21A6", "\\\\mapsto{}"),
  c("\u21A9", "\\\\hookleftarrow{}"),
  c("\u21AA", "\\\\hookrightarrow{}"),
  c("\u21AB", "\\\\looparrowleft{}"),
  c("\u21AC", "\\\\looparrowright{}"),
  c("\u21AD", "\\\\leftrightsquigarrow{}"),
  c("\u21AE", "\\\\nleftrightarrow{}"),
  c("\u21B0", "\\\\Lsh{}"),
  c("\u21B1", "\\\\Rsh{}"),
  c("\u21B3", "\\\\ElsevierGlyph{21B3}"),
  c("\u21B6", "\\\\curvearrowleft{}"),
  c("\u21B7", "\\\\curvearrowright{}"),
  c("\u21BA", "\\\\circlearrowleft{}"),
  c("\u21BB", "\\\\circlearrowright{}"),
  c("\u21BC", "\\\\leftharpoonup{}"),
  c("\u21BD", "\\\\leftharpoondown{}"),
  c("\u21BE", "\\\\upharpoonright{}"),
  c("\u21BF", "\\\\upharpoonleft{}"),
  c("\u21C0", "\\\\rightharpoonup{}"),
  c("\u21C1", "\\\\rightharpoondown{}"),
  c("\u21C2", "\\\\downharpoonright{}"),
  c("\u21C3", "\\\\downharpoonleft{}"),
  c("\u21C4", "\\\\rightleftarrows{}"),
  c("\u21C5", "\\\\dblarrowupdown{}"),
  c("\u21C6", "\\\\leftrightarrows{}"),
  c("\u21C7", "\\\\leftleftarrows{}"),
  c("\u21C8", "\\\\upuparrows{}"),
  c("\u21C9", "\\\\rightrightarrows{}"),
  c("\u21CA", "\\\\downdownarrows{}"),
  c("\u21CB", "\\\\leftrightharpoons{}"),
  c("\u21CC", "\\\\rightleftharpoons{}"),
  c("\u21CD", "\\\\nLeftarrow{}"),
  c("\u21CE", "\\\\nLeftrightarrow{}"),
  c("\u21CF", "\\\\nRightarrow{}"),
  c("\u21D0", "\\\\Leftarrow{}"),
  c("\u21D1", "\\\\Uparrow{}"),
  c("\u21D2", "\\\\Rightarrow{}"),
  c("\u21D3", "\\\\Downarrow{}"),
  c("\u21D4", "\\\\Leftrightarrow{}"),
  c("\u21D5", "\\\\Updownarrow{}"),
  c("\u21DA", "\\\\Lleftarrow{}"),
  c("\u21DB", "\\\\Rrightarrow{}"),
  c("\u21DD", "\\\\rightsquigarrow{}"),
  c("\u21F5", "\\\\DownArrowUpArrow{}"),
  c("\u2200", "\\\\forall{}"),
  c("\u2201", "\\\\complement{}"),
  c("\u2202", "\\\\partial{}"),
  c("\u2203", "\\\\exists{}"),
  c("\u2204", "\\\\nexists{}"),
  c("\u2205", "\\\\varnothing{}"),
  c("\u2207", "\\\\nabla{}"),
  c("\u2208", "\\\\in{}"),
  c("\u2209", "\\\\not\\\\in{}"),
  c("\u220B", "\\\\ni{}"),
  c("\u220C", "\\\\not\\\\ni{}"),
  c("\u220F", "\\\\prod{}"),
  c("\u2210", "\\\\coprod{}"),
  c("\u2211", "\\\\sum{}"),
  c("\u2212", "\\\\textminus{}"),
  c("\u2213", "\\\\mp{}"),
  c("\u2214", "\\\\dotplus{}"),
  c("\u2216", "\\\\setminus{}"),
  c("\u2217", "\\\\textasteriskcentered{}"),
  c("\u2218", "\\\\circ{}"),
  c("\u2219", "\\\\bullet{}"),
  c("\u221A", "\\\\surd{}"),
  c("\u221D", "\\\\propto{}"),
  c("\u221E", "\\\\infty{}"),
  c("\u221F", "\\\\rightangle{}"),
  c("\u2220", "\\\\angle{}"),
  c("\u2221", "\\\\measuredangle{}"),
  c("\u2222", "\\\\sphericalangle{}"),
  c("\u2223", "\\\\mid{}"),
  c("\u2224", "\\\\nmid{}"),
  c("\u2225", "\\\\parallel{}"),
  c("\u2226", "\\\\nparallel{}"),
  c("\u2227", "\\\\wedge{}"),
  c("\u2228", "\\\\vee{}"),
  c("\u2229", "\\\\cap{}"),
  c("\u222A", "\\\\cup{}"),
  c("\u222B", "\\\\int{}"),
  c("\u222C", "\\\\int\\\\!\\\\int{}"),
  c("\u222D", "\\\\int\\\\!\\\\int\\\\!\\\\int{}"),
  c("\u222E", "\\\\oint{}"),
  c("\u222F", "\\\\surfintegral{}"),
  c("\u2230", "\\\\volintegral{}"),
  c("\u2231", "\\\\clwintegral{}"),
  c("\u2232", "\\\\ElsevierGlyph{2232}"),
  c("\u2233", "\\\\ElsevierGlyph{2233}"),
  c("\u2234", "\\\\therefore{}"),
  c("\u2235", "\\\\because{}"),
  c("\u2237", "\\\\Colon{}"),
  c("\u2238", "\\\\ElsevierGlyph{2238}"),
  c("\u223A", "\\\\mathbin{{,}\\\\!\\\\!{-}\\\\!\\\\!{,}}"),
  c("\u223B", "\\\\homothetic{}"),
  c("\u223C", "\\\\sim{}"),
  c("\u223D", "\\\\backsim{}"),
  c("\u223E", "\\\\lazysinv{}"),
  c("\u2240", "\\\\wr{}"),
  c("\u2241", "\\\\not\\\\sim{}"),
  c("\u2242", "\\\\ElsevierGlyph{2242}"),
  c("\u2243", "\\\\simeq{}"),
  c("\u2244", "\\\\not\\\\simeq{}"),
  c("\u2245", "\\\\cong{}"),
  c("\u2246", "\\\\approxnotequal{}"),
  c("\u2247", "\\\\not\\\\cong{}"),
  c("\u2248", "\\\\approx{}"),
  c("\u2249", "\\\\not\\\\approx{}"),
  c("\u224A", "\\\\approxeq{}"),
  c("\u224B", "\\\\tildetrpl{}"),
  c("\u224B-00338", "\\\\not\\\\apid{}"),
  c("\u224C", "\\\\allequal{}"),
  c("\u224D", "\\\\asymp{}"),
  c("\u224E", "\\\\Bumpeq{}"),
  c("\u224F", "\\\\bumpeq{}"),
  c("\u224F-00338", "\\\\NotHumpEqual{}"),
  c("\u2250", "\\\\doteq{}"),
  c("\u2250-00338", "\\\\not\\\\doteq"),
  c("\u2251", "\\\\doteqdot{}"),
  c("\u2252", "\\\\fallingdotseq{}"),
  c("\u2253", "\\\\risingdotseq{}"),
  c("\u2254", ":="),
  c("\u2255", "=:"),
  c("\u2256", "\\\\eqcirc{}"),
  c("\u2257", "\\\\circeq{}"),
  c("\u2259", "\\\\estimates{}"),
  c("\u225A", "\\\\ElsevierGlyph{225A}"),
  c("\u225B", "\\\\starequal{}"),
  c("\u225C", "\\\\triangleq{}"),
  c("\u225F", "\\\\ElsevierGlyph{225F}"),
  c("\u2260", "\\\\not ="),
  c("\u2261", "\\\\equiv{}"),
  c("\u2262", "\\\\not\\\\equiv{}"),
  c("\u2264", "\\\\leq{}"),
  c("\u2265", "\\\\geq{}"),
  c("\u2266", "\\\\leqq{}"),
  c("\u2267", "\\\\geqq{}"),
  c("\u2268", "\\\\lneqq{}"),
  c("\u2269", "\\\\gneqq{}"),
  c("\u226A", "\\\\ll{}"),
  c("\u226B", "\\\\gg{}"),
  c("\u226C", "\\\\between{}"),
  c("\u226D", "\\\\not\\\\kern-0.3em\\\\times{}"),
  c("\u226E", "\\\\not&lt;"),
  c("\u226F", "\\\\not&gt;"),
  c("\u2270", "\\\\not\\\\leq{}"),
  c("\u2271", "\\\\not\\\\geq{}"),
  c("\u2272", "\\\\lessequivlnt{}"),
  c("\u2273", "\\\\greaterequivlnt{}"),
  c("\u2274", "\\\\ElsevierGlyph{2274}"),
  c("\u2275", "\\\\ElsevierGlyph{2275}"),
  c("\u2276", "\\\\lessgtr{}"),
  c("\u2277", "\\\\gtrless{}"),
  c("\u2278", "\\\\notlessgreater{}"),
  c("\u2279", "\\\\notgreaterless{}"),
  c("\u227A", "\\\\prec{}"),
  c("\u227B", "\\\\succ{}"),
  c("\u227C", "\\\\preccurlyeq{}"),
  c("\u227D", "\\\\succcurlyeq{}"),
  c("\u227E", "\\\\precapprox{}"),
  c("\u227F", "\\\\succapprox{}"),
  c("\u2280", "\\\\not\\\\prec{}"),
  c("\u2281", "\\\\not\\\\succ{}"),
  c("\u2282", "\\\\subset{}"),
  c("\u2283", "\\\\supset{}"),
  c("\u2284", "\\\\not\\\\subset{}"),
  c("\u2285", "\\\\not\\\\supset{}"),
  c("\u2286", "\\\\subseteq{}"),
  c("\u2287", "\\\\supseteq{}"),
  c("\u2288", "\\\\not\\\\subseteq{}"),
  c("\u2289", "\\\\not\\\\supseteq{}"),
  c("\u228A", "\\\\subsetneq{}"),
  c("\u228B", "\\\\supsetneq{}"),
  c("\u228E", "\\\\uplus{}"),
  c("\u228F", "\\\\sqsubset{}"),
  c("\u2290", "\\\\sqsupset{}"),
  c("\u2291", "\\\\sqsubseteq{}"),
  c("\u2292", "\\\\sqsupseteq{}"),
  c("\u2293", "\\\\sqcap{}"),
  c("\u2294", "\\\\sqcup{}"),
  c("\u2295", "\\\\oplus{}"),
  c("\u2296", "\\\\ominus{}"),
  c("\u2297", "\\\\otimes{}"),
  c("\u2298", "\\\\oslash{}"),
  c("\u2299", "\\\\odot{}"),
  c("\u229A", "\\\\circledcirc{}"),
  c("\u229B", "\\\\circledast{}"),
  c("\u229D", "\\\\circleddash{}"),
  c("\u229E", "\\\\boxplus{}"),
  c("\u229F", "\\\\boxminus{}"),
  c("\u22A0", "\\\\boxtimes{}"),
  c("\u22A1", "\\\\boxdot{}"),
  c("\u22A2", "\\\\vdash{}"),
  c("\u22A3", "\\\\dashv{}"),
  c("\u22A4", "\\\\top{}"),
  c("\u22A5", "\\\\perp{}"),
  c("\u22A7", "\\\\truestate{}"),
  c("\u22A8", "\\\\forcesextra{}"),
  c("\u22A9", "\\\\Vdash{}"),
  c("\u22AA", "\\\\Vvdash{}"),
  c("\u22AB", "\\\\VDash{}"),
  c("\u22AC", "\\\\nvdash{}"),
  c("\u22AD", "\\\\nvDash{}"),
  c("\u22AE", "\\\\nVdash{}"),
  c("\u22AF", "\\\\nVDash{}"),
  c("\u22B2", "\\\\vartriangleleft{}"),
  c("\u22B3", "\\\\vartriangleright{}"),
  c("\u22B4", "\\\\trianglelefteq{}"),
  c("\u22B5", "\\\\trianglerighteq{}"),
  c("\u22B6", "\\\\original{}"),
  c("\u22B7", "\\\\image{}"),
  c("\u22B8", "\\\\multimap{}"),
  c("\u22B9", "\\\\hermitconjmatrix{}"),
  c("\u22BA", "\\\\intercal{}"),
  c("\u22BB", "\\\\veebar{}"),
  c("\u22BE", "\\\\rightanglearc{}"),
  c("\u22C0", "\\\\ElsevierGlyph{22C0}"),
  c("\u22C1", "\\\\ElsevierGlyph{22C1}"),
  c("\u22C2", "\\\\bigcap{}"),
  c("\u22C3", "\\\\bigcup{}"),
  c("\u22C4", "\\\\diamond{}"),
  c("\u22C5", "\\\\cdot{}"),
  c("\u22C6", "\\\\star{}"),
  c("\u22C7", "\\\\divideontimes{}"),
  c("\u22C8", "\\\\bowtie{}"),
  c("\u22C9", "\\\\ltimes{}"),
  c("\u22CA", "\\\\rtimes{}"),
  c("\u22CB", "\\\\leftthreetimes{}"),
  c("\u22CC", "\\\\rightthreetimes{}"),
  c("\u22CD", "\\\\backsimeq{}"),
  c("\u22CE", "\\\\curlyvee{}"),
  c("\u22CF", "\\\\curlywedge{}"),
  c("\u22D0", "\\\\Subset{}"),
  c("\u22D1", "\\\\Supset{}"),
  c("\u22D2", "\\\\Cap{}"),
  c("\u22D3", "\\\\Cup{}"),
  c("\u22D4", "\\\\pitchfork{}"),
  c("\u22D6", "\\\\lessdot{}"),
  c("\u22D7", "\\\\gtrdot{}"),
  c("\u22D8", "\\\\verymuchless{}"),
  c("\u22D9", "\\\\verymuchgreater{}"),
  c("\u22DA", "\\\\lesseqgtr{}"),
  c("\u22DB", "\\\\gtreqless{}"),
  c("\u22DE", "\\\\curlyeqprec{}"),
  c("\u22DF", "\\\\curlyeqsucc{}"),
  c("\u22E2", "\\\\not\\\\sqsubseteq{}"),
  c("\u22E3", "\\\\not\\\\sqsupseteq{}"),
  c("\u22E5", "\\\\Elzsqspne{}"),
  c("\u22E6", "\\\\lnsim{}"),
  c("\u22E7", "\\\\gnsim{}"),
  c("\u22E8", "\\\\precedesnotsimilar{}"),
  c("\u22E9", "\\\\succnsim{}"),
  c("\u22EA", "\\\\ntriangleleft{}"),
  c("\u22EB", "\\\\ntriangleright{}"),
  c("\u22EC", "\\\\ntrianglelefteq{}"),
  c("\u22ED", "\\\\ntrianglerighteq{}"),
  c("\u22EE", "\\\\vdots{}"),
  c("\u22EF", "\\\\cdots{}"),
  c("\u22F0", "\\\\upslopeellipsis{}"),
  c("\u22F1", "\\\\downslopeellipsis{}"),
  c("\u2305", "\\\\barwedge{}"),
  c("\u2306", "\\\\perspcorrespond{}"),
  c("\u2308", "\\\\lceil{}"),
  c("\u2309", "\\\\rceil{}"),
  c("\u230A", "\\\\lfloor{}"),
  c("\u230B", "\\\\rfloor{}"),
  c("\u2315", "\\\\recorder{}"),
  c("\u2316", "\\\\mathchar\"2208"),
  c("\u231C", "\\\\ulcorner{}"),
  c("\u231D", "\\\\urcorner{}"),
  c("\u231E", "\\\\llcorner{}"),
  c("\u231F", "\\\\lrcorner{}"),
  c("\u2322", "\\\\frown{}"),
  c("\u2323", "\\\\smile{}"),
  c("\u2329", "\\\\langle{}"),
  c("\u232A", "\\\\rangle{}"),
  c("\u233D", "\\\\ElsevierGlyph{E838}"),
  c("\u23A3", "\\\\Elzdlcorn{}"),
  c("\u23B0", "\\\\lmoustache{}"),
  c("\u23B1", "\\\\rmoustache{}"),
  c("\u2422", "\\\\textblank{}"),
  c("\u2423", "\\\\textvisiblespace{}"),
  c("\u2460", "\\\\ding{172}"),
  c("\u2461", "\\\\ding{173}"),
  c("\u2462", "\\\\ding{174}"),
  c("\u2463", "\\\\ding{175}"),
  c("\u2464", "\\\\ding{176}"),
  c("\u2465", "\\\\ding{177}"),
  c("\u2466", "\\\\ding{178}"),
  c("\u2467", "\\\\ding{179}"),
  c("\u2468", "\\\\ding{180}"),
  c("\u2469", "\\\\ding{181}"),
  c("\u24C8", "\\\\circledS{}"),
  c("\u2506", "\\\\Elzdshfnc{}"),
  c("\u2519", "\\\\Elzsqfnw{}"),
  c("\u2571", "\\\\diagup{}"),
  c("\u25A0", "\\\\ding{110}"),
  c("\u25A1", "\\\\square{}"),
  c("\u25AA", "\\\\blacksquare{}"),
  c("\u25AD", "\\\\fbox{~~}"),
  c("\u25AF", "\\\\Elzvrecto{}"),
  c("\u25B1", "\\\\ElsevierGlyph{E381}"),
  c("\u25B2", "\\\\ding{115}"),
  c("\u25B3", "\\\\bigtriangleup{}"),
  c("\u25B4", "\\\\blacktriangle{}"),
  c("\u25B5", "\\\\vartriangle{}"),
  c("\u25B8", "\\\\blacktriangleright{}"),
  c("\u25B9", "\\\\triangleright{}"),
  c("\u25BC", "\\\\ding{116}"),
  c("\u25BD", "\\\\bigtriangledown{}"),
  c("\u25BE", "\\\\blacktriangledown{}"),
  c("\u25BF", "\\\\triangledown{}"),
  c("\u25C2", "\\\\blacktriangleleft{}"),
  c("\u25C3", "\\\\triangleleft{}"),
  c("\u25C6", "\\\\ding{117}"),
  c("\u25CA", "\\\\lozenge{}"),
  c("\u25CB", "\\\\bigcirc{}"),
  c("\u25CF", "\\\\ding{108}"),
  c("\u25D0", "\\\\Elzcirfl{}"),
  c("\u25D1", "\\\\Elzcirfr{}"),
  c("\u25D2", "\\\\Elzcirfb{}"),
  c("\u25D7", "\\\\ding{119}"),
  c("\u25D8", "\\\\Elzrvbull{}"),
  c("\u25E6", "\\\\textopenbullet{}"),
  c("\u25E7", "\\\\Elzsqfl{}"),
  c("\u25E8", "\\\\Elzsqfr{}"),
  c("\u25EA", "\\\\Elzsqfse{}"),
  c("\u25EF", "\\\\bigcirc{}"),
  c("\u2605", "\\\\ding{72}"),
  c("\u2606", "\\\\ding{73}"),
  c("\u260E", "\\\\ding{37}"),
  c("\u261B", "\\\\ding{42}"),
  c("\u261E", "\\\\ding{43}"),
  c("\u263E", "\\\\rightmoon{}"),
  c("\u263F", "\\\\mercury{}"),
  c("\u2640", "\\\\venus{}"),
  c("\u2642", "\\\\male{}"),
  c("\u2643", "\\\\jupiter{}"),
  c("\u2644", "\\\\saturn{}"),
  c("\u2645", "\\\\uranus{}"),
  c("\u2646", "\\\\neptune{}"),
  c("\u2647", "\\\\pluto{}"),
  c("\u2648", "\\\\aries{}"),
  c("\u2649", "\\\\taurus{}"),
  c("\u264A", "\\\\gemini{}"),
  c("\u264B", "\\\\cancer{}"),
  c("\u264C", "\\\\leo{}"),
  c("\u264D", "\\\\virgo{}"),
  c("\u264E", "\\\\libra{}"),
  c("\u264F", "\\\\scorpio{}"),
  c("\u2650", "\\\\sagittarius{}"),
  c("\u2651", "\\\\capricornus{}"),
  c("\u2652", "\\\\aquarius{}"),
  c("\u2653", "\\\\pisces{}"),
  c("\u2660", "\\\\ding{171}"),
  c("\u2662", "\\\\diamond{}"),
  c("\u2663", "\\\\ding{168}"),
  c("\u2665", "\\\\ding{170}"),
  c("\u2666", "\\\\ding{169}"),
  c("\u2669", "\\\\quarternote{}"),
  c("\u266A", "\\\\eighthnote{}"),
  c("\u266D", "\\\\flat{}"),
  c("\u266E", "\\\\natural{}"),
  c("\u266F", "\\\\sharp{}"),
  c("\u2701", "\\\\ding{33}"),
  c("\u2702", "\\\\ding{34}"),
  c("\u2703", "\\\\ding{35}"),
  c("\u2704", "\\\\ding{36}"),
  c("\u2706", "\\\\ding{38}"),
  c("\u2707", "\\\\ding{39}"),
  c("\u2708", "\\\\ding{40}"),
  c("\u2709", "\\\\ding{41}"),
  c("\u270C", "\\\\ding{44}"),
  c("\u270D", "\\\\ding{45}"),
  c("\u270E", "\\\\ding{46}"),
  c("\u270F", "\\\\ding{47}"),
  c("\u2710", "\\\\ding{48}"),
  c("\u2711", "\\\\ding{49}"),
  c("\u2712", "\\\\ding{50}"),
  c("\u2713", "\\\\ding{51}"),
  c("\u2714", "\\\\ding{52}"),
  c("\u2715", "\\\\ding{53}"),
  c("\u2716", "\\\\ding{54}"),
  c("\u2717", "\\\\ding{55}"),
  c("\u2718", "\\\\ding{56}"),
  c("\u2719", "\\\\ding{57}"),
  c("\u271A", "\\\\ding{58}"),
  c("\u271B", "\\\\ding{59}"),
  c("\u271C", "\\\\ding{60}"),
  c("\u271D", "\\\\ding{61}"),
  c("\u271E", "\\\\ding{62}"),
  c("\u271F", "\\\\ding{63}"),
  c("\u2720", "\\\\ding{64}"),
  c("\u2721", "\\\\ding{65}"),
  c("\u2722", "\\\\ding{66}"),
  c("\u2723", "\\\\ding{67}"),
  c("\u2724", "\\\\ding{68}"),
  c("\u2725", "\\\\ding{69}"),
  c("\u2726", "\\\\ding{70}"),
  c("\u2727", "\\\\ding{71}"),
  c("\u2729", "\\\\ding{73}"),
  c("\u272A", "\\\\ding{74}"),
  c("\u272B", "\\\\ding{75}"),
  c("\u272C", "\\\\ding{76}"),
  c("\u272D", "\\\\ding{77}"),
  c("\u272E", "\\\\ding{78}"),
  c("\u272F", "\\\\ding{79}"),
  c("\u2730", "\\\\ding{80}"),
  c("\u2731", "\\\\ding{81}"),
  c("\u2732", "\\\\ding{82}"),
  c("\u2733", "\\\\ding{83}"),
  c("\u2734", "\\\\ding{84}"),
  c("\u2735", "\\\\ding{85}"),
  c("\u2736", "\\\\ding{86}"),
  c("\u2737", "\\\\ding{87}"),
  c("\u2738", "\\\\ding{88}"),
  c("\u2739", "\\\\ding{89}"),
  c("\u273A", "\\\\ding{90}"),
  c("\u273B", "\\\\ding{91}"),
  c("\u273C", "\\\\ding{92}"),
  c("\u273D", "\\\\ding{93}"),
  c("\u273E", "\\\\ding{94}"),
  c("\u273F", "\\\\ding{95}"),
  c("\u2740", "\\\\ding{96}"),
  c("\u2741", "\\\\ding{97}"),
  c("\u2742", "\\\\ding{98}"),
  c("\u2743", "\\\\ding{99}"),
  c("\u2744", "\\\\ding{100}"),
  c("\u2745", "\\\\ding{101}"),
  c("\u2746", "\\\\ding{102}"),
  c("\u2747", "\\\\ding{103}"),
  c("\u2748", "\\\\ding{104}"),
  c("\u2749", "\\\\ding{105}"),
  c("\u274A", "\\\\ding{106}"),
  c("\u274B", "\\\\ding{107}"),
  c("\u274D", "\\\\ding{109}"),
  c("\u274F", "\\\\ding{111}"),
  c("\u2750", "\\\\ding{112}"),
  c("\u2751", "\\\\ding{113}"),
  c("\u2752", "\\\\ding{114}"),
  c("\u2756", "\\\\ding{118}"),
  c("\u2758", "\\\\ding{120}"),
  c("\u2759", "\\\\ding{121}"),
  c("\u275A", "\\\\ding{122}"),
  c("\u275B", "\\\\ding{123}"),
  c("\u275C", "\\\\ding{124}"),
  c("\u275D", "\\\\ding{125}"),
  c("\u275E", "\\\\ding{126}"),
  c("\u2761", "\\\\ding{161}"),
  c("\u2762", "\\\\ding{162}"),
  c("\u2763", "\\\\ding{163}"),
  c("\u2764", "\\\\ding{164}"),
  c("\u2765", "\\\\ding{165}"),
  c("\u2766", "\\\\ding{166}"),
  c("\u2767", "\\\\ding{167}"),
  c("\u2776", "\\\\ding{182}"),
  c("\u2777", "\\\\ding{183}"),
  c("\u2778", "\\\\ding{184}"),
  c("\u2779", "\\\\ding{185}"),
  c("\u277A", "\\\\ding{186}"),
  c("\u277B", "\\\\ding{187}"),
  c("\u277C", "\\\\ding{188}"),
  c("\u277D", "\\\\ding{189}"),
  c("\u277E", "\\\\ding{190}"),
  c("\u277F", "\\\\ding{191}"),
  c("\u2780", "\\\\ding{192}"),
  c("\u2781", "\\\\ding{193}"),
  c("\u2782", "\\\\ding{194}"),
  c("\u2783", "\\\\ding{195}"),
  c("\u2784", "\\\\ding{196}"),
  c("\u2785", "\\\\ding{197}"),
  c("\u2786", "\\\\ding{198}"),
  c("\u2787", "\\\\ding{199}"),
  c("\u2788", "\\\\ding{200}"),
  c("\u2789", "\\\\ding{201}"),
  c("\u278A", "\\\\ding{202}"),
  c("\u278B", "\\\\ding{203}"),
  c("\u278C", "\\\\ding{204}"),
  c("\u278D", "\\\\ding{205}"),
  c("\u278E", "\\\\ding{206}"),
  c("\u278F", "\\\\ding{207}"),
  c("\u2790", "\\\\ding{208}"),
  c("\u2791", "\\\\ding{209}"),
  c("\u2792", "\\\\ding{210}"),
  c("\u2793", "\\\\ding{211}"),
  c("\u2794", "\\\\ding{212}"),
  c("\u2798", "\\\\ding{216}"),
  c("\u2799", "\\\\ding{217}"),
  c("\u279A", "\\\\ding{218}"),
  c("\u279B", "\\\\ding{219}"),
  c("\u279C", "\\\\ding{220}"),
  c("\u279D", "\\\\ding{221}"),
  c("\u279E", "\\\\ding{222}"),
  c("\u279F", "\\\\ding{223}"),
  c("\u27A0", "\\\\ding{224}"),
  c("\u27A1", "\\\\ding{225}"),
  c("\u27A2", "\\\\ding{226}"),
  c("\u27A3", "\\\\ding{227}"),
  c("\u27A4", "\\\\ding{228}"),
  c("\u27A5", "\\\\ding{229}"),
  c("\u27A6", "\\\\ding{230}"),
  c("\u27A7", "\\\\ding{231}"),
  c("\u27A8", "\\\\ding{232}"),
  c("\u27A9", "\\\\ding{233}"),
  c("\u27AA", "\\\\ding{234}"),
  c("\u27AB", "\\\\ding{235}"),
  c("\u27AC", "\\\\ding{236}"),
  c("\u27AD", "\\\\ding{237}"),
  c("\u27AE", "\\\\ding{238}"),
  c("\u27AF", "\\\\ding{239}"),
  c("\u27B1", "\\\\ding{241}"),
  c("\u27B2", "\\\\ding{242}"),
  c("\u27B3", "\\\\ding{243}"),
  c("\u27B4", "\\\\ding{244}"),
  c("\u27B5", "\\\\ding{245}"),
  c("\u27B6", "\\\\ding{246}"),
  c("\u27B7", "\\\\ding{247}"),
  c("\u27B8", "\\\\ding{248}"),
  c("\u27B9", "\\\\ding{249}"),
  c("\u27BA", "\\\\ding{250}"),
  c("\u27BB", "\\\\ding{251}"),
  c("\u27BC", "\\\\ding{252}"),
  c("\u27BD", "\\\\ding{253}"),
  c("\u27BE", "\\\\ding{254}"),
  c("\u27F5", "\\\\longleftarrow{}"),
  c("\u27F6", "\\\\longrightarrow{}"),
  c("\u27F7", "\\\\longleftrightarrow{}"),
  c("\u27F8", "\\\\Longleftarrow{}"),
  c("\u27F9", "\\\\Longrightarrow{}"),
  c("\u27FA", "\\\\Longleftrightarrow{}"),
  c("\u27FC", "\\\\longmapsto{}"),
  c("\u27FF", "\\\\sim\\\\joinrel\\\\leadsto"),
  c("\u2905", "\\\\ElsevierGlyph{E212}"),
  c("\u2912", "\\\\UpArrowBar{}"),
  c("\u2913", "\\\\DownArrowBar{}"),
  c("\u2923", "\\\\ElsevierGlyph{E20C}"),
  c("\u2924", "\\\\ElsevierGlyph{E20D}"),
  c("\u2925", "\\\\ElsevierGlyph{E20B}"),
  c("\u2926", "\\\\ElsevierGlyph{E20A}"),
  c("\u2927", "\\\\ElsevierGlyph{E211}"),
  c("\u2928", "\\\\ElsevierGlyph{E20E}"),
  c("\u2929", "\\\\ElsevierGlyph{E20F}"),
  c("\u292A", "\\\\ElsevierGlyph{E210}"),
  c("\u2933", "\\\\ElsevierGlyph{E21C}"),
  c("\u2936", "\\\\ElsevierGlyph{E21A}"),
  c("\u2937", "\\\\ElsevierGlyph{E219}"),
  c("\u2940", "\\\\Elolarr{}"),
  c("\u2941", "\\\\Elorarr{}"),
  c("\u2942", "\\\\ElzRlarr{}"),
  c("\u2944", "\\\\ElzrLarr{}"),
  c("\u2947", "\\\\Elzrarrx{}"),
  c("\u294E", "\\\\LeftRightVector{}"),
  c("\u294F", "\\\\RightUpDownVector{}"),
  c("\u2950", "\\\\DownLeftRightVector{}"),
  c("\u2951", "\\\\LeftUpDownVector{}"),
  c("\u2952", "\\\\LeftVectorBar{}"),
  c("\u2953", "\\\\RightVectorBar{}"),
  c("\u2954", "\\\\RightUpVectorBar{}"),
  c("\u2955", "\\\\RightDownVectorBar{}"),
  c("\u2956", "\\\\DownLeftVectorBar{}"),
  c("\u2957", "\\\\DownRightVectorBar{}"),
  c("\u2958", "\\\\LeftUpVectorBar{}"),
  c("\u2959", "\\\\LeftDownVectorBar{}"),
  c("\u295A", "\\\\LeftTeeVector{}"),
  c("\u295B", "\\\\RightTeeVector{}"),
  c("\u295C", "\\\\RightUpTeeVector{}"),
  c("\u295D", "\\\\RightDownTeeVector{}"),
  c("\u295E", "\\\\DownLeftTeeVector{}"),
  c("\u295F", "\\\\DownRightTeeVector{}"),
  c("\u2960", "\\\\LeftUpTeeVector{}"),
  c("\u2961", "\\\\LeftDownTeeVector{}"),
  c("\u296E", "\\\\UpEquilibrium{}"),
  c("\u296F", "\\\\ReverseUpEquilibrium{}"),
  c("\u2970", "\\\\RoundImplies{}"),
  c("\u297C", "\\\\ElsevierGlyph{E214}"),
  c("\u297D", "\\\\ElsevierGlyph{E215}"),
  c("\u2980", "\\\\Elztfnc{}"),
  c("\u2985", "\\\\ElsevierGlyph{3018}"),
  c("\u2986", "\\\\Elroang{}"),
  c("\u2993", "\\\\lparenless{}"),
  c("\u2994", "\\\\ElsevierGlyph{E291}"),
  c("\u2999", "\\\\Elzddfnc{}"),
  c("\u299C", "\\\\Angle{}"),
  c("\u29A0", "\\\\Elzlpargt{}"),
  c("\u29B5", "\\\\ElsevierGlyph{E260}"),
  c("\u29B6", "\\\\ElsevierGlyph{E61B}"),
  c("\u29CA", "\\\\ElzLap{}"),
  c("\u29CB", "\\\\Elzdefas{}"),
  c("\u29CF", "\\\\LeftTriangleBar{}"),
  c("\u29D0", "\\\\RightTriangleBar{}"),
  c("\u29DC", "\\\\ElsevierGlyph{E372}"),
  c("\u29EB", "\\\\blacklozenge{}"),
  c("\u29F4", "\\\\RuleDelayed{}"),
  c("\u2A04", "\\\\Elxuplus{}"),
  c("\u2A05", "\\\\ElzThr{}"),
  c("\u2A06", "\\\\Elxsqcup{}"),
  c("\u2A07", "\\\\ElzInf{}"),
  c("\u2A08", "\\\\ElzSup{}"),
  c("\u2A0D", "\\\\ElzCint{}"),
  c("\u2A0F", "\\\\clockoint{}"),
  c("\u2A10", "\\\\ElsevierGlyph{E395}"),
  c("\u2A16", "\\\\sqrint{}"),
  c("\u2A25", "\\\\ElsevierGlyph{E25A}"),
  c("\u2A2A", "\\\\ElsevierGlyph{E25B}"),
  c("\u2A2D", "\\\\ElsevierGlyph{E25C}"),
  c("\u2A2E", "\\\\ElsevierGlyph{E25D}"),
  c("\u2A2F", "\\\\ElzTimes{}"),
  c("\u2A34", "\\\\ElsevierGlyph{E25E}"),
  c("\u2A35", "\\\\ElsevierGlyph{E25E}"),
  c("\u2A3C", "\\\\ElsevierGlyph{E259}"),
  c("\u2A3F", "\\\\amalg{}"),
  c("\u2A53", "\\\\ElzAnd{}"),
  c("\u2A54", "\\\\ElzOr{}"),
  c("\u2A55", "\\\\ElsevierGlyph{E36E}"),
  c("\u2A56", "\\\\ElOr{}"),
  c("\u2A5E", "\\\\perspcorrespond{}"),
  c("\u2A5F", "\\\\Elzminhat{}"),
  c("\u2A63", "\\\\ElsevierGlyph{225A}"),
  c("\u2A6E", "\\\\stackrel{*}{=}"),
  c("\u2A75", "\\\\Equal{}"),
  c("\u2A7D", "\\\\leqslant{}"),
  c("\u2A7E", "\\\\geqslant{}"),
  c("\u2A85", "\\\\lessapprox{}"),
  c("\u2A86", "\\\\gtrapprox{}"),
  c("\u2A87", "\\\\lneq{}"),
  c("\u2A88", "\\\\gneq{}"),
  c("\u2A89", "\\\\lnapprox{}"),
  c("\u2A8A", "\\\\gnapprox{}"),
  c("\u2A8B", "\\\\lesseqqgtr{}"),
  c("\u2A8C", "\\\\gtreqqless{}"),
  c("\u2A95", "\\\\eqslantless{}"),
  c("\u2A96", "\\\\eqslantgtr{}"),
  c("\u2A9D", "\\\\Pisymbol{ppi020}{117}"),
  c("\u2A9E", "\\\\Pisymbol{ppi020}{105}"),
  c("\u2AA1", "\\\\NestedLessLess{}"),
  c("\u2AA2", "\\\\NestedGreaterGreater{}"),
  c("\u2AAF", "\\\\preceq{}"),
  c("\u2AB0", "\\\\succeq{}"),
  c("\u2AB5", "\\\\precneqq{}"),
  c("\u2AB6", "\\\\succneqq{}"),
  c("\u2AB7", "\\\\precapprox{}"),
  c("\u2AB8", "\\\\succapprox{}"),
  c("\u2AB9", "\\\\precnapprox{}"),
  c("\u2ABA", "\\\\succnapprox{}"),
  c("\u2AC5", "\\\\subseteqq{}"),
  c("\u2AC6", "\\\\supseteqq{}"),
  c("\u2ACB", "\\\\subsetneqq{}"),
  c("\u2ACC", "\\\\supsetneqq{}"),
  c("\u2AEB", "\\\\ElsevierGlyph{E30D}"),
  c("\u2AF6", "\\\\Elztdcol{}"),
  c("\u2AFD", "{{/}\\\\!\\\\!{/}}"),
  c("\u2E18", "\\\\textinterrobangdown{}"),
  c("\u3008", "\\\\textlangle{}"),
  c("\u3009", "\\\\textrangle{}"),
  c("\u300A", "\\\\ElsevierGlyph{300A}"),
  c("\u300B", "\\\\ElsevierGlyph{300B}"),
  c("\u3018", "\\\\ElsevierGlyph{3018}"),
  c("\u3019", "\\\\ElsevierGlyph{3019}"),
  c("\u301A", "\\\\openbracketleft{}"),
  c("\u301B", "\\\\openbracketright{}"),
  c("\uD400", "\\\\mathbf{A}"),
  c("\uD401", "\\\\mathbf{B}"),
  c("\uD402", "\\\\mathbf{C}"),
  c("\uD403", "\\\\mathbf{D}"),
  c("\uD404", "\\\\mathbf{E}"),
  c("\uD405", "\\\\mathbf{F}"),
  c("\uD406", "\\\\mathbf{G}"),
  c("\uD407", "\\\\mathbf{H}"),
  c("\uD408", "\\\\mathbf{I}"),
  c("\uD409", "\\\\mathbf{J}"),
  c("\uD40A", "\\\\mathbf{K}"),
  c("\uD40B", "\\\\mathbf{L}"),
  c("\uD40C", "\\\\mathbf{M}"),
  c("\uD40D", "\\\\mathbf{N}"),
  c("\uD40E", "\\\\mathbf{O}"),
  c("\uD40F", "\\\\mathbf{P}"),
  c("\uD410", "\\\\mathbf{Q}"),
  c("\uD411", "\\\\mathbf{R}"),
  c("\uD412", "\\\\mathbf{S}"),
  c("\uD413", "\\\\mathbf{T}"),
  c("\uD414", "\\\\mathbf{U}"),
  c("\uD415", "\\\\mathbf{V}"),
  c("\uD416", "\\\\mathbf{W}"),
  c("\uD417", "\\\\mathbf{X}"),
  c("\uD418", "\\\\mathbf{Y}"),
  c("\uD419", "\\\\mathbf{Z}"),
  c("\uD41A", "\\\\mathbf{a}"),
  c("\uD41B", "\\\\mathbf{b}"),
  c("\uD41C", "\\\\mathbf{c}"),
  c("\uD41D", "\\\\mathbf{d}"),
  c("\uD41E", "\\\\mathbf{e}"),
  c("\uD41F", "\\\\mathbf{f}"),
  c("\uD420", "\\\\mathbf{g}"),
  c("\uD421", "\\\\mathbf{h}"),
  c("\uD422", "\\\\mathbf{i}"),
  c("\uD423", "\\\\mathbf{j}"),
  c("\uD424", "\\\\mathbf{k}"),
  c("\uD425", "\\\\mathbf{l}"),
  c("\uD426", "\\\\mathbf{m}"),
  c("\uD427", "\\\\mathbf{n}"),
  c("\uD428", "\\\\mathbf{o}"),
  c("\uD429", "\\\\mathbf{p}"),
  c("\uD42A", "\\\\mathbf{q}"),
  c("\uD42B", "\\\\mathbf{r}"),
  c("\uD42C", "\\\\mathbf{s}"),
  c("\uD42D", "\\\\mathbf{t}"),
  c("\uD42E", "\\\\mathbf{u}"),
  c("\uD42F", "\\\\mathbf{v}"),
  c("\uD430", "\\\\mathbf{w}"),
  c("\uD431", "\\\\mathbf{x}"),
  c("\uD432", "\\\\mathbf{y}"),
  c("\uD433", "\\\\mathbf{z}"),
  c("\uD434", "\\\\mathsl{A}"),
  c("\uD435", "\\\\mathsl{B}"),
  c("\uD436", "\\\\mathsl{C}"),
  c("\uD437", "\\\\mathsl{D}"),
  c("\uD438", "\\\\mathsl{E}"),
  c("\uD439", "\\\\mathsl{F}"),
  c("\uD43A", "\\\\mathsl{G}"),
  c("\uD43B", "\\\\mathsl{H}"),
  c("\uD43C", "\\\\mathsl{I}"),
  c("\uD43D", "\\\\mathsl{J}"),
  c("\uD43E", "\\\\mathsl{K}"),
  c("\uD43F", "\\\\mathsl{L}"),
  c("\uD440", "\\\\mathsl{M}"),
  c("\uD441", "\\\\mathsl{N}"),
  c("\uD442", "\\\\mathsl{O}"),
  c("\uD443", "\\\\mathsl{P}"),
  c("\uD444", "\\\\mathsl{Q}"),
  c("\uD445", "\\\\mathsl{R}"),
  c("\uD446", "\\\\mathsl{S}"),
  c("\uD447", "\\\\mathsl{T}"),
  c("\uD448", "\\\\mathsl{U}"),
  c("\uD449", "\\\\mathsl{V}"),
  c("\uD44A", "\\\\mathsl{W}"),
  c("\uD44B", "\\\\mathsl{X}"),
  c("\uD44C", "\\\\mathsl{Y}"),
  c("\uD44D", "\\\\mathsl{Z}"),
  c("\uD44E", "\\\\mathsl{a}"),
  c("\uD44F", "\\\\mathsl{b}"),
  c("\uD450", "\\\\mathsl{c}"),
  c("\uD451", "\\\\mathsl{d}"),
  c("\uD452", "\\\\mathsl{e}"),
  c("\uD453", "\\\\mathsl{f}"),
  c("\uD454", "\\\\mathsl{g}"),
  c("\uD456", "\\\\mathsl{i}"),
  c("\uD457", "\\\\mathsl{j}"),
  c("\uD458", "\\\\mathsl{k}"),
  c("\uD459", "\\\\mathsl{l}"),
  c("\uD45A", "\\\\mathsl{m}"),
  c("\uD45B", "\\\\mathsl{n}"),
  c("\uD45C", "\\\\mathsl{o}"),
  c("\uD45D", "\\\\mathsl{p}"),
  c("\uD45E", "\\\\mathsl{q}"),
  c("\uD45F", "\\\\mathsl{r}"),
  c("\uD460", "\\\\mathsl{s}"),
  c("\uD461", "\\\\mathsl{t}"),
  c("\uD462", "\\\\mathsl{u}"),
  c("\uD463", "\\\\mathsl{v}"),
  c("\uD464", "\\\\mathsl{w}"),
  c("\uD465", "\\\\mathsl{x}"),
  c("\uD466", "\\\\mathsl{y}"),
  c("\uD467", "\\\\mathsl{z}"),
  c("\uD468", "\\\\mathbit{A}"),
  c("\uD469", "\\\\mathbit{B}"),
  c("\uD46A", "\\\\mathbit{C}"),
  c("\uD46B", "\\\\mathbit{D}"),
  c("\uD46C", "\\\\mathbit{E}"),
  c("\uD46D", "\\\\mathbit{F}"),
  c("\uD46E", "\\\\mathbit{G}"),
  c("\uD46F", "\\\\mathbit{H}"),
  c("\uD470", "\\\\mathbit{I}"),
  c("\uD471", "\\\\mathbit{J}"),
  c("\uD472", "\\\\mathbit{K}"),
  c("\uD473", "\\\\mathbit{L}"),
  c("\uD474", "\\\\mathbit{M}"),
  c("\uD475", "\\\\mathbit{N}"),
  c("\uD476", "\\\\mathbit{O}"),
  c("\uD477", "\\\\mathbit{P}"),
  c("\uD478", "\\\\mathbit{Q}"),
  c("\uD479", "\\\\mathbit{R}"),
  c("\uD47A", "\\\\mathbit{S}"),
  c("\uD47B", "\\\\mathbit{T}"),
  c("\uD47C", "\\\\mathbit{U}"),
  c("\uD47D", "\\\\mathbit{V}"),
  c("\uD47E", "\\\\mathbit{W}"),
  c("\uD47F", "\\\\mathbit{X}"),
  c("\uD480", "\\\\mathbit{Y}"),
  c("\uD481", "\\\\mathbit{Z}"),
  c("\uD482", "\\\\mathbit{a}"),
  c("\uD483", "\\\\mathbit{b}"),
  c("\uD484", "\\\\mathbit{c}"),
  c("\uD485", "\\\\mathbit{d}"),
  c("\uD486", "\\\\mathbit{e}"),
  c("\uD487", "\\\\mathbit{f}"),
  c("\uD488", "\\\\mathbit{g}"),
  c("\uD489", "\\\\mathbit{h}"),
  c("\uD48A", "\\\\mathbit{i}"),
  c("\uD48B", "\\\\mathbit{j}"),
  c("\uD48C", "\\\\mathbit{k}"),
  c("\uD48D", "\\\\mathbit{l}"),
  c("\uD48E", "\\\\mathbit{m}"),
  c("\uD48F", "\\\\mathbit{n}"),
  c("\uD490", "\\\\mathbit{o}"),
  c("\uD491", "\\\\mathbit{p}"),
  c("\uD492", "\\\\mathbit{q}"),
  c("\uD493", "\\\\mathbit{r}"),
  c("\uD494", "\\\\mathbit{s}"),
  c("\uD495", "\\\\mathbit{t}"),
  c("\uD496", "\\\\mathbit{u}"),
  c("\uD497", "\\\\mathbit{v}"),
  c("\uD498", "\\\\mathbit{w}"),
  c("\uD499", "\\\\mathbit{x}"),
  c("\uD49A", "\\\\mathbit{y}"),
  c("\uD49B", "\\\\mathbit{z}"),
  c("\uD49C", "\\\\mathscr{A}"),
  c("\uD49E", "\\\\mathscr{C}"),
  c("\uD49F", "\\\\mathscr{D}"),
  c("\uD4A2", "\\\\mathscr{G}"),
  c("\uD4A5", "\\\\mathscr{J}"),
  c("\uD4A6", "\\\\mathscr{K}"),
  c("\uD4A9", "\\\\mathscr{N}"),
  c("\uD4AA", "\\\\mathscr{O}"),
  c("\uD4AB", "\\\\mathscr{P}"),
  c("\uD4AC", "\\\\mathscr{Q}"),
  c("\uD4AE", "\\\\mathscr{S}"),
  c("\uD4AF", "\\\\mathscr{T}"),
  c("\uD4B0", "\\\\mathscr{U}"),
  c("\uD4B1", "\\\\mathscr{V}"),
  c("\uD4B2", "\\\\mathscr{W}"),
  c("\uD4B3", "\\\\mathscr{X}"),
  c("\uD4B4", "\\\\mathscr{Y}"),
  c("\uD4B5", "\\\\mathscr{Z}"),
  c("\uD4B6", "\\\\mathscr{a}"),
  c("\uD4B7", "\\\\mathscr{b}"),
  c("\uD4B8", "\\\\mathscr{c}"),
  c("\uD4B9", "\\\\mathscr{d}"),
  c("\uD4BB", "\\\\mathscr{f}"),
  c("\uD4BD", "\\\\mathscr{h}"),
  c("\uD4BE", "\\\\mathscr{i}"),
  c("\uD4BF", "\\\\mathscr{j}"),
  c("\uD4C0", "\\\\mathscr{k}"),
  c("\uD4C1", "\\\\mathscr{l}"),
  c("\uD4C2", "\\\\mathscr{m}"),
  c("\uD4C3", "\\\\mathscr{n}"),
  c("\uD4C5", "\\\\mathscr{p}"),
  c("\uD4C6", "\\\\mathscr{q}"),
  c("\uD4C7", "\\\\mathscr{r}"),
  c("\uD4C8", "\\\\mathscr{s}"),
  c("\uD4C9", "\\\\mathscr{t}"),
  c("\uD4CA", "\\\\mathscr{u}"),
  c("\uD4CB", "\\\\mathscr{v}"),
  c("\uD4CC", "\\\\mathscr{w}"),
  c("\uD4CD", "\\\\mathscr{x}"),
  c("\uD4CE", "\\\\mathscr{y}"),
  c("\uD4CF", "\\\\mathscr{z}"),
  c("\uD4D0", "\\\\mathmit{A}"),
  c("\uD4D1", "\\\\mathmit{B}"),
  c("\uD4D2", "\\\\mathmit{C}"),
  c("\uD4D3", "\\\\mathmit{D}"),
  c("\uD4D4", "\\\\mathmit{E}"),
  c("\uD4D5", "\\\\mathmit{F}"),
  c("\uD4D6", "\\\\mathmit{G}"),
  c("\uD4D7", "\\\\mathmit{H}"),
  c("\uD4D8", "\\\\mathmit{I}"),
  c("\uD4D9", "\\\\mathmit{J}"),
  c("\uD4DA", "\\\\mathmit{K}"),
  c("\uD4DB", "\\\\mathmit{L}"),
  c("\uD4DC", "\\\\mathmit{M}"),
  c("\uD4DD", "\\\\mathmit{N}"),
  c("\uD4DE", "\\\\mathmit{O}"),
  c("\uD4DF", "\\\\mathmit{P}"),
  c("\uD4E0", "\\\\mathmit{Q}"),
  c("\uD4E1", "\\\\mathmit{R}"),
  c("\uD4E2", "\\\\mathmit{S}"),
  c("\uD4E3", "\\\\mathmit{T}"),
  c("\uD4E4", "\\\\mathmit{U}"),
  c("\uD4E5", "\\\\mathmit{V}"),
  c("\uD4E6", "\\\\mathmit{W}"),
  c("\uD4E7", "\\\\mathmit{X}"),
  c("\uD4E8", "\\\\mathmit{Y}"),
  c("\uD4E9", "\\\\mathmit{Z}"),
  c("\uD4EA", "\\\\mathmit{a}"),
  c("\uD4EB", "\\\\mathmit{b}"),
  c("\uD4EC", "\\\\mathmit{c}"),
  c("\uD4ED", "\\\\mathmit{d}"),
  c("\uD4EE", "\\\\mathmit{e}"),
  c("\uD4EF", "\\\\mathmit{f}"),
  c("\uD4F0", "\\\\mathmit{g}"),
  c("\uD4F1", "\\\\mathmit{h}"),
  c("\uD4F2", "\\\\mathmit{i}"),
  c("\uD4F3", "\\\\mathmit{j}"),
  c("\uD4F4", "\\\\mathmit{k}"),
  c("\uD4F5", "\\\\mathmit{l}"),
  c("\uD4F6", "\\\\mathmit{m}"),
  c("\uD4F7", "\\\\mathmit{n}"),
  c("\uD4F8", "\\\\mathmit{o}"),
  c("\uD4F9", "\\\\mathmit{p}"),
  c("\uD4FA", "\\\\mathmit{q}"),
  c("\uD4FB", "\\\\mathmit{r}"),
  c("\uD4FC", "\\\\mathmit{s}"),
  c("\uD4FD", "\\\\mathmit{t}"),
  c("\uD4FE", "\\\\mathmit{u}"),
  c("\uD4FF", "\\\\mathmit{v}"),
  c("\uD500", "\\\\mathmit{w}"),
  c("\uD501", "\\\\mathmit{x}"),
  c("\uD502", "\\\\mathmit{y}"),
  c("\uD503", "\\\\mathmit{z}"),
  c("\uD504", "\\\\mathfrak{A}"),
  c("\uD505", "\\\\mathfrak{B}"),
  c("\uD507", "\\\\mathfrak{D}"),
  c("\uD508", "\\\\mathfrak{E}"),
  c("\uD509", "\\\\mathfrak{F}"),
  c("\uD50A", "\\\\mathfrak{G}"),
  c("\uD50D", "\\\\mathfrak{J}"),
  c("\uD50E", "\\\\mathfrak{K}"),
  c("\uD50F", "\\\\mathfrak{L}"),
  c("\uD510", "\\\\mathfrak{M}"),
  c("\uD511", "\\\\mathfrak{N}"),
  c("\uD512", "\\\\mathfrak{O}"),
  c("\uD513", "\\\\mathfrak{P}"),
  c("\uD514", "\\\\mathfrak{Q}"),
  c("\uD516", "\\\\mathfrak{S}"),
  c("\uD517", "\\\\mathfrak{T}"),
  c("\uD518", "\\\\mathfrak{U}"),
  c("\uD519", "\\\\mathfrak{V}"),
  c("\uD51A", "\\\\mathfrak{W}"),
  c("\uD51B", "\\\\mathfrak{X}"),
  c("\uD51C", "\\\\mathfrak{Y}"),
  c("\uD51E", "\\\\mathfrak{a}"),
  c("\uD51F", "\\\\mathfrak{b}"),
  c("\uD520", "\\\\mathfrak{c}"),
  c("\uD521", "\\\\mathfrak{d}"),
  c("\uD522", "\\\\mathfrak{e}"),
  c("\uD523", "\\\\mathfrak{f}"),
  c("\uD524", "\\\\mathfrak{g}"),
  c("\uD525", "\\\\mathfrak{h}"),
  c("\uD526", "\\\\mathfrak{i}"),
  c("\uD527", "\\\\mathfrak{j}"),
  c("\uD528", "\\\\mathfrak{k}"),
  c("\uD529", "\\\\mathfrak{l}"),
  c("\uD52A", "\\\\mathfrak{m}"),
  c("\uD52B", "\\\\mathfrak{n}"),
  c("\uD52C", "\\\\mathfrak{o}"),
  c("\uD52D", "\\\\mathfrak{p}"),
  c("\uD52E", "\\\\mathfrak{q}"),
  c("\uD52F", "\\\\mathfrak{r}"),
  c("\uD530", "\\\\mathfrak{s}"),
  c("\uD531", "\\\\mathfrak{t}"),
  c("\uD532", "\\\\mathfrak{u}"),
  c("\uD533", "\\\\mathfrak{v}"),
  c("\uD534", "\\\\mathfrak{w}"),
  c("\uD535", "\\\\mathfrak{x}"),
  c("\uD536", "\\\\mathfrak{y}"),
  c("\uD537", "\\\\mathfrak{z}"),
  c("\uD538", "\\\\mathbb{A}"),
  c("\uD539", "\\\\mathbb{B}"),
  c("\uD53B", "\\\\mathbb{D}"),
  c("\uD53C", "\\\\mathbb{E}"),
  c("\uD53D", "\\\\mathbb{F}"),
  c("\uD53E", "\\\\mathbb{G}"),
  c("\uD540", "\\\\mathbb{I}"),
  c("\uD541", "\\\\mathbb{J}"),
  c("\uD542", "\\\\mathbb{K}"),
  c("\uD543", "\\\\mathbb{L}"),
  c("\uD544", "\\\\mathbb{M}"),
  c("\uD546", "\\\\mathbb{O}"),
  c("\uD54A", "\\\\mathbb{S}"),
  c("\uD54B", "\\\\mathbb{T}"),
  c("\uD54C", "\\\\mathbb{U}"),
  c("\uD54D", "\\\\mathbb{V}"),
  c("\uD54E", "\\\\mathbb{W}"),
  c("\uD54F", "\\\\mathbb{X}"),
  c("\uD550", "\\\\mathbb{Y}"),
  c("\uD552", "\\\\mathbb{a}"),
  c("\uD553", "\\\\mathbb{b}"),
  c("\uD554", "\\\\mathbb{c}"),
  c("\uD555", "\\\\mathbb{d}"),
  c("\uD556", "\\\\mathbb{e}"),
  c("\uD557", "\\\\mathbb{f}"),
  c("\uD558", "\\\\mathbb{g}"),
  c("\uD559", "\\\\mathbb{h}"),
  c("\uD55A", "\\\\mathbb{i}"),
  c("\uD55B", "\\\\mathbb{j}"),
  c("\uD55C", "\\\\mathbb{k}"),
  c("\uD55D", "\\\\mathbb{l}"),
  c("\uD55E", "\\\\mathbb{m}"),
  c("\uD55F", "\\\\mathbb{n}"),
  c("\uD560", "\\\\mathbb{o}"),
  c("\uD561", "\\\\mathbb{p}"),
  c("\uD562", "\\\\mathbb{q}"),
  c("\uD563", "\\\\mathbb{r}"),
  c("\uD564", "\\\\mathbb{s}"),
  c("\uD565", "\\\\mathbb{t}"),
  c("\uD566", "\\\\mathbb{u}"),
  c("\uD567", "\\\\mathbb{v}"),
  c("\uD568", "\\\\mathbb{w}"),
  c("\uD569", "\\\\mathbb{x}"),
  c("\uD56A", "\\\\mathbb{y}"),
  c("\uD56B", "\\\\mathbb{z}"),
  c("\uD56C", "\\\\mathslbb{A}"),
  c("\uD56D", "\\\\mathslbb{B}"),
  c("\uD56E", "\\\\mathslbb{C}"),
  c("\uD56F", "\\\\mathslbb{D}"),
  c("\uD570", "\\\\mathslbb{E}"),
  c("\uD571", "\\\\mathslbb{F}"),
  c("\uD572", "\\\\mathslbb{G}"),
  c("\uD573", "\\\\mathslbb{H}"),
  c("\uD574", "\\\\mathslbb{I}"),
  c("\uD575", "\\\\mathslbb{J}"),
  c("\uD576", "\\\\mathslbb{K}"),
  c("\uD577", "\\\\mathslbb{L}"),
  c("\uD578", "\\\\mathslbb{M}"),
  c("\uD579", "\\\\mathslbb{N}"),
  c("\uD57A", "\\\\mathslbb{O}"),
  c("\uD57B", "\\\\mathslbb{P}"),
  c("\uD57C", "\\\\mathslbb{Q}"),
  c("\uD57D", "\\\\mathslbb{R}"),
  c("\uD57E", "\\\\mathslbb{S}"),
  c("\uD57F", "\\\\mathslbb{T}"),
  c("\uD580", "\\\\mathslbb{U}"),
  c("\uD581", "\\\\mathslbb{V}"),
  c("\uD582", "\\\\mathslbb{W}"),
  c("\uD583", "\\\\mathslbb{X}"),
  c("\uD584", "\\\\mathslbb{Y}"),
  c("\uD585", "\\\\mathslbb{Z}"),
  c("\uD586", "\\\\mathslbb{a}"),
  c("\uD587", "\\\\mathslbb{b}"),
  c("\uD588", "\\\\mathslbb{c}"),
  c("\uD589", "\\\\mathslbb{d}"),
  c("\uD58A", "\\\\mathslbb{e}"),
  c("\uD58B", "\\\\mathslbb{f}"),
  c("\uD58C", "\\\\mathslbb{g}"),
  c("\uD58D", "\\\\mathslbb{h}"),
  c("\uD58E", "\\\\mathslbb{i}"),
  c("\uD58F", "\\\\mathslbb{j}"),
  c("\uD590", "\\\\mathslbb{k}"),
  c("\uD591", "\\\\mathslbb{l}"),
  c("\uD592", "\\\\mathslbb{m}"),
  c("\uD593", "\\\\mathslbb{n}"),
  c("\uD594", "\\\\mathslbb{o}"),
  c("\uD595", "\\\\mathslbb{p}"),
  c("\uD596", "\\\\mathslbb{q}"),
  c("\uD597", "\\\\mathslbb{r}"),
  c("\uD598", "\\\\mathslbb{s}"),
  c("\uD599", "\\\\mathslbb{t}"),
  c("\uD59A", "\\\\mathslbb{u}"),
  c("\uD59B", "\\\\mathslbb{v}"),
  c("\uD59C", "\\\\mathslbb{w}"),
  c("\uD59D", "\\\\mathslbb{x}"),
  c("\uD59E", "\\\\mathslbb{y}"),
  c("\uD59F", "\\\\mathslbb{z}"),
  c("\uD5A0", "\\\\mathsf{A}"),
  c("\uD5A1", "\\\\mathsf{B}"),
  c("\uD5A2", "\\\\mathsf{C}"),
  c("\uD5A3", "\\\\mathsf{D}"),
  c("\uD5A4", "\\\\mathsf{E}"),
  c("\uD5A5", "\\\\mathsf{F}"),
  c("\uD5A6", "\\\\mathsf{G}"),
  c("\uD5A7", "\\\\mathsf{H}"),
  c("\uD5A8", "\\\\mathsf{I}"),
  c("\uD5A9", "\\\\mathsf{J}"),
  c("\uD5AA", "\\\\mathsf{K}"),
  c("\uD5AB", "\\\\mathsf{L}"),
  c("\uD5AC", "\\\\mathsf{M}"),
  c("\uD5AD", "\\\\mathsf{N}"),
  c("\uD5AE", "\\\\mathsf{O}"),
  c("\uD5AF", "\\\\mathsf{P}"),
  c("\uD5B0", "\\\\mathsf{Q}"),
  c("\uD5B1", "\\\\mathsf{R}"),
  c("\uD5B2", "\\\\mathsf{S}"),
  c("\uD5B3", "\\\\mathsf{T}"),
  c("\uD5B4", "\\\\mathsf{U}"),
  c("\uD5B5", "\\\\mathsf{V}"),
  c("\uD5B6", "\\\\mathsf{W}"),
  c("\uD5B7", "\\\\mathsf{X}"),
  c("\uD5B8", "\\\\mathsf{Y}"),
  c("\uD5B9", "\\\\mathsf{Z}"),
  c("\uD5BA", "\\\\mathsf{a}"),
  c("\uD5BB", "\\\\mathsf{b}"),
  c("\uD5BC", "\\\\mathsf{c}"),
  c("\uD5BD", "\\\\mathsf{d}"),
  c("\uD5BE", "\\\\mathsf{e}"),
  c("\uD5BF", "\\\\mathsf{f}"),
  c("\uD5C0", "\\\\mathsf{g}"),
  c("\uD5C1", "\\\\mathsf{h}"),
  c("\uD5C2", "\\\\mathsf{i}"),
  c("\uD5C3", "\\\\mathsf{j}"),
  c("\uD5C4", "\\\\mathsf{k}"),
  c("\uD5C5", "\\\\mathsf{l}"),
  c("\uD5C6", "\\\\mathsf{m}"),
  c("\uD5C7", "\\\\mathsf{n}"),
  c("\uD5C8", "\\\\mathsf{o}"),
  c("\uD5C9", "\\\\mathsf{p}"),
  c("\uD5CA", "\\\\mathsf{q}"),
  c("\uD5CB", "\\\\mathsf{r}"),
  c("\uD5CC", "\\\\mathsf{s}"),
  c("\uD5CD", "\\\\mathsf{t}"),
  c("\uD5CE", "\\\\mathsf{u}"),
  c("\uD5CF", "\\\\mathsf{v}"),
  c("\uD5D0", "\\\\mathsf{w}"),
  c("\uD5D1", "\\\\mathsf{x}"),
  c("\uD5D2", "\\\\mathsf{y}"),
  c("\uD5D3", "\\\\mathsf{z}"),
  c("\uD5D4", "\\\\mathsfbf{A}"),
  c("\uD5D5", "\\\\mathsfbf{B}"),
  c("\uD5D6", "\\\\mathsfbf{C}"),
  c("\uD5D7", "\\\\mathsfbf{D}"),
  c("\uD5D8", "\\\\mathsfbf{E}"),
  c("\uD5D9", "\\\\mathsfbf{F}"),
  c("\uD5DA", "\\\\mathsfbf{G}"),
  c("\uD5DB", "\\\\mathsfbf{H}"),
  c("\uD5DC", "\\\\mathsfbf{I}"),
  c("\uD5DD", "\\\\mathsfbf{J}"),
  c("\uD5DE", "\\\\mathsfbf{K}"),
  c("\uD5DF", "\\\\mathsfbf{L}"),
  c("\uD5E0", "\\\\mathsfbf{M}"),
  c("\uD5E1", "\\\\mathsfbf{N}"),
  c("\uD5E2", "\\\\mathsfbf{O}"),
  c("\uD5E3", "\\\\mathsfbf{P}"),
  c("\uD5E4", "\\\\mathsfbf{Q}"),
  c("\uD5E5", "\\\\mathsfbf{R}"),
  c("\uD5E6", "\\\\mathsfbf{S}"),
  c("\uD5E7", "\\\\mathsfbf{T}"),
  c("\uD5E8", "\\\\mathsfbf{U}"),
  c("\uD5E9", "\\\\mathsfbf{V}"),
  c("\uD5EA", "\\\\mathsfbf{W}"),
  c("\uD5EB", "\\\\mathsfbf{X}"),
  c("\uD5EC", "\\\\mathsfbf{Y}"),
  c("\uD5ED", "\\\\mathsfbf{Z}"),
  c("\uD5EE", "\\\\mathsfbf{a}"),
  c("\uD5EF", "\\\\mathsfbf{b}"),
  c("\uD5F0", "\\\\mathsfbf{c}"),
  c("\uD5F1", "\\\\mathsfbf{d}"),
  c("\uD5F2", "\\\\mathsfbf{e}"),
  c("\uD5F3", "\\\\mathsfbf{f}"),
  c("\uD5F4", "\\\\mathsfbf{g}"),
  c("\uD5F5", "\\\\mathsfbf{h}"),
  c("\uD5F6", "\\\\mathsfbf{i}"),
  c("\uD5F7", "\\\\mathsfbf{j}"),
  c("\uD5F8", "\\\\mathsfbf{k}"),
  c("\uD5F9", "\\\\mathsfbf{l}"),
  c("\uD5FA", "\\\\mathsfbf{m}"),
  c("\uD5FB", "\\\\mathsfbf{n}"),
  c("\uD5FC", "\\\\mathsfbf{o}"),
  c("\uD5FD", "\\\\mathsfbf{p}"),
  c("\uD5FE", "\\\\mathsfbf{q}"),
  c("\uD5FF", "\\\\mathsfbf{r}"),
  c("\uD600", "\\\\mathsfbf{s}"),
  c("\uD601", "\\\\mathsfbf{t}"),
  c("\uD602", "\\\\mathsfbf{u}"),
  c("\uD603", "\\\\mathsfbf{v}"),
  c("\uD604", "\\\\mathsfbf{w}"),
  c("\uD605", "\\\\mathsfbf{x}"),
  c("\uD606", "\\\\mathsfbf{y}"),
  c("\uD607", "\\\\mathsfbf{z}"),
  c("\uD608", "\\\\mathsfsl{A}"),
  c("\uD609", "\\\\mathsfsl{B}"),
  c("\uD60A", "\\\\mathsfsl{C}"),
  c("\uD60B", "\\\\mathsfsl{D}"),
  c("\uD60C", "\\\\mathsfsl{E}"),
  c("\uD60D", "\\\\mathsfsl{F}"),
  c("\uD60E", "\\\\mathsfsl{G}"),
  c("\uD60F", "\\\\mathsfsl{H}"),
  c("\uD610", "\\\\mathsfsl{I}"),
  c("\uD611", "\\\\mathsfsl{J}"),
  c("\uD612", "\\\\mathsfsl{K}"),
  c("\uD613", "\\\\mathsfsl{L}"),
  c("\uD614", "\\\\mathsfsl{M}"),
  c("\uD615", "\\\\mathsfsl{N}"),
  c("\uD616", "\\\\mathsfsl{O}"),
  c("\uD617", "\\\\mathsfsl{P}"),
  c("\uD618", "\\\\mathsfsl{Q}"),
  c("\uD619", "\\\\mathsfsl{R}"),
  c("\uD61A", "\\\\mathsfsl{S}"),
  c("\uD61B", "\\\\mathsfsl{T}"),
  c("\uD61C", "\\\\mathsfsl{U}"),
  c("\uD61D", "\\\\mathsfsl{V}"),
  c("\uD61E", "\\\\mathsfsl{W}"),
  c("\uD61F", "\\\\mathsfsl{X}"),
  c("\uD620", "\\\\mathsfsl{Y}"),
  c("\uD621", "\\\\mathsfsl{Z}"),
  c("\uD622", "\\\\mathsfsl{a}"),
  c("\uD623", "\\\\mathsfsl{b}"),
  c("\uD624", "\\\\mathsfsl{c}"),
  c("\uD625", "\\\\mathsfsl{d}"),
  c("\uD626", "\\\\mathsfsl{e}"),
  c("\uD627", "\\\\mathsfsl{f}"),
  c("\uD628", "\\\\mathsfsl{g}"),
  c("\uD629", "\\\\mathsfsl{h}"),
  c("\uD62A", "\\\\mathsfsl{i}"),
  c("\uD62B", "\\\\mathsfsl{j}"),
  c("\uD62C", "\\\\mathsfsl{k}"),
  c("\uD62D", "\\\\mathsfsl{l}"),
  c("\uD62E", "\\\\mathsfsl{m}"),
  c("\uD62F", "\\\\mathsfsl{n}"),
  c("\uD630", "\\\\mathsfsl{o}"),
  c("\uD631", "\\\\mathsfsl{p}"),
  c("\uD632", "\\\\mathsfsl{q}"),
  c("\uD633", "\\\\mathsfsl{r}"),
  c("\uD634", "\\\\mathsfsl{s}"),
  c("\uD635", "\\\\mathsfsl{t}"),
  c("\uD636", "\\\\mathsfsl{u}"),
  c("\uD637", "\\\\mathsfsl{v}"),
  c("\uD638", "\\\\mathsfsl{w}"),
  c("\uD639", "\\\\mathsfsl{x}"),
  c("\uD63A", "\\\\mathsfsl{y}"),
  c("\uD63B", "\\\\mathsfsl{z}"),
  c("\uD63C", "\\\\mathsfbfsl{A}"),
  c("\uD63D", "\\\\mathsfbfsl{B}"),
  c("\uD63E", "\\\\mathsfbfsl{C}"),
  c("\uD63F", "\\\\mathsfbfsl{D}"),
  c("\uD640", "\\\\mathsfbfsl{E}"),
  c("\uD641", "\\\\mathsfbfsl{F}"),
  c("\uD642", "\\\\mathsfbfsl{G}"),
  c("\uD643", "\\\\mathsfbfsl{H}"),
  c("\uD644", "\\\\mathsfbfsl{I}"),
  c("\uD645", "\\\\mathsfbfsl{J}"),
  c("\uD646", "\\\\mathsfbfsl{K}"),
  c("\uD647", "\\\\mathsfbfsl{L}"),
  c("\uD648", "\\\\mathsfbfsl{M}"),
  c("\uD649", "\\\\mathsfbfsl{N}"),
  c("\uD64A", "\\\\mathsfbfsl{O}"),
  c("\uD64B", "\\\\mathsfbfsl{P}"),
  c("\uD64C", "\\\\mathsfbfsl{Q}"),
  c("\uD64D", "\\\\mathsfbfsl{R}"),
  c("\uD64E", "\\\\mathsfbfsl{S}"),
  c("\uD64F", "\\\\mathsfbfsl{T}"),
  c("\uD650", "\\\\mathsfbfsl{U}"),
  c("\uD651", "\\\\mathsfbfsl{V}"),
  c("\uD652", "\\\\mathsfbfsl{W}"),
  c("\uD653", "\\\\mathsfbfsl{X}"),
  c("\uD654", "\\\\mathsfbfsl{Y}"),
  c("\uD655", "\\\\mathsfbfsl{Z}"),
  c("\uD656", "\\\\mathsfbfsl{a}"),
  c("\uD657", "\\\\mathsfbfsl{b}"),
  c("\uD658", "\\\\mathsfbfsl{c}"),
  c("\uD659", "\\\\mathsfbfsl{d}"),
  c("\uD65A", "\\\\mathsfbfsl{e}"),
  c("\uD65B", "\\\\mathsfbfsl{f}"),
  c("\uD65C", "\\\\mathsfbfsl{g}"),
  c("\uD65D", "\\\\mathsfbfsl{h}"),
  c("\uD65E", "\\\\mathsfbfsl{i}"),
  c("\uD65F", "\\\\mathsfbfsl{j}"),
  c("\uD660", "\\\\mathsfbfsl{k}"),
  c("\uD661", "\\\\mathsfbfsl{l}"),
  c("\uD662", "\\\\mathsfbfsl{m}"),
  c("\uD663", "\\\\mathsfbfsl{n}"),
  c("\uD664", "\\\\mathsfbfsl{o}"),
  c("\uD665", "\\\\mathsfbfsl{p}"),
  c("\uD666", "\\\\mathsfbfsl{q}"),
  c("\uD667", "\\\\mathsfbfsl{r}"),
  c("\uD668", "\\\\mathsfbfsl{s}"),
  c("\uD669", "\\\\mathsfbfsl{t}"),
  c("\uD66A", "\\\\mathsfbfsl{u}"),
  c("\uD66B", "\\\\mathsfbfsl{v}"),
  c("\uD66C", "\\\\mathsfbfsl{w}"),
  c("\uD66D", "\\\\mathsfbfsl{x}"),
  c("\uD66E", "\\\\mathsfbfsl{y}"),
  c("\uD66F", "\\\\mathsfbfsl{z}"),
  c("\uD670", "\\\\mathtt{A}"),
  c("\uD671", "\\\\mathtt{B}"),
  c("\uD672", "\\\\mathtt{C}"),
  c("\uD673", "\\\\mathtt{D}"),
  c("\uD674", "\\\\mathtt{E}"),
  c("\uD675", "\\\\mathtt{F}"),
  c("\uD676", "\\\\mathtt{G}"),
  c("\uD677", "\\\\mathtt{H}"),
  c("\uD678", "\\\\mathtt{I}"),
  c("\uD679", "\\\\mathtt{J}"),
  c("\uD67A", "\\\\mathtt{K}"),
  c("\uD67B", "\\\\mathtt{L}"),
  c("\uD67C", "\\\\mathtt{M}"),
  c("\uD67D", "\\\\mathtt{N}"),
  c("\uD67E", "\\\\mathtt{O}"),
  c("\uD67F", "\\\\mathtt{P}"),
  c("\uD680", "\\\\mathtt{Q}"),
  c("\uD681", "\\\\mathtt{R}"),
  c("\uD682", "\\\\mathtt{S}"),
  c("\uD683", "\\\\mathtt{T}"),
  c("\uD684", "\\\\mathtt{U}"),
  c("\uD685", "\\\\mathtt{V}"),
  c("\uD686", "\\\\mathtt{W}"),
  c("\uD687", "\\\\mathtt{X}"),
  c("\uD688", "\\\\mathtt{Y}"),
  c("\uD689", "\\\\mathtt{Z}"),
  c("\uD68A", "\\\\mathtt{a}"),
  c("\uD68B", "\\\\mathtt{b}"),
  c("\uD68C", "\\\\mathtt{c}"),
  c("\uD68D", "\\\\mathtt{d}"),
  c("\uD68E", "\\\\mathtt{e}"),
  c("\uD68F", "\\\\mathtt{f}"),
  c("\uD690", "\\\\mathtt{g}"),
  c("\uD691", "\\\\mathtt{h}"),
  c("\uD692", "\\\\mathtt{i}"),
  c("\uD693", "\\\\mathtt{j}"),
  c("\uD694", "\\\\mathtt{k}"),
  c("\uD695", "\\\\mathtt{l}"),
  c("\uD696", "\\\\mathtt{m}"),
  c("\uD697", "\\\\mathtt{n}"),
  c("\uD698", "\\\\mathtt{o}"),
  c("\uD699", "\\\\mathtt{p}"),
  c("\uD69A", "\\\\mathtt{q}"),
  c("\uD69B", "\\\\mathtt{r}"),
  c("\uD69C", "\\\\mathtt{s}"),
  c("\uD69D", "\\\\mathtt{t}"),
  c("\uD69E", "\\\\mathtt{u}"),
  c("\uD69F", "\\\\mathtt{v}"),
  c("\uD6A0", "\\\\mathtt{w}"),
  c("\uD6A1", "\\\\mathtt{x}"),
  c("\uD6A2", "\\\\mathtt{y}"),
  c("\uD6A3", "\\\\mathtt{z}"),
  c("\uD6A8", "\\\\mathbf{\\\\Alpha}"),
  c("\uD6A9", "\\\\mathbf{\\\\Beta}"),
  c("\uD6AA", "\\\\mathbf{\\\\Gamma}"),
  c("\uD6AB", "\\\\mathbf{\\\\Delta}"),
  c("\uD6AC", "\\\\mathbf{\\\\Epsilon}"),
  c("\uD6AD", "\\\\mathbf{\\\\Zeta}"),
  c("\uD6AE", "\\\\mathbf{\\\\Eta}"),
  c("\uD6AF", "\\\\mathbf{\\\\Theta}"),
  c("\uD6B0", "\\\\mathbf{\\\\Iota}"),
  c("\uD6B1", "\\\\mathbf{\\\\Kappa}"),
  c("\uD6B2", "\\\\mathbf{\\\\Lambda}"),
  c("\uD6B5", "\\\\mathbf{\\\\Xi}"),
  c("\uD6B7", "\\\\mathbf{\\\\Pi}"),
  c("\uD6B8", "\\\\mathbf{\\\\Rho}"),
  c("\uD6B9", "\\\\mathbf{\\\\vartheta}"),
  c("\uD6BA", "\\\\mathbf{\\\\Sigma}"),
  c("\uD6BB", "\\\\mathbf{\\\\Tau}"),
  c("\uD6BC", "\\\\mathbf{\\\\Upsilon}"),
  c("\uD6BD", "\\\\mathbf{\\\\Phi}"),
  c("\uD6BE", "\\\\mathbf{\\\\Chi}"),
  c("\uD6BF", "\\\\mathbf{\\\\Psi}"),
  c("\uD6C0", "\\\\mathbf{\\\\Omega}"),
  c("\uD6C1", "\\\\mathbf{\\\\nabla}"),
  c("\uD6C2", "\\\\mathbf{\\\\Alpha}"),
  c("\uD6C3", "\\\\mathbf{\\\\Beta}"),
  c("\uD6C4", "\\\\mathbf{\\\\Gamma}"),
  c("\uD6C5", "\\\\mathbf{\\\\Delta}"),
  c("\uD6C6", "\\\\mathbf{\\\\Epsilon}"),
  c("\uD6C7", "\\\\mathbf{\\\\Zeta}"),
  c("\uD6C8", "\\\\mathbf{\\\\Eta}"),
  c("\uD6C9", "\\\\mathbf{\\\\theta}"),
  c("\uD6CA", "\\\\mathbf{\\\\Iota}"),
  c("\uD6CB", "\\\\mathbf{\\\\Kappa}"),
  c("\uD6CC", "\\\\mathbf{\\\\Lambda}"),
  c("\uD6CF", "\\\\mathbf{\\\\Xi}"),
  c("\uD6D1", "\\\\mathbf{\\\\Pi}"),
  c("\uD6D2", "\\\\mathbf{\\\\Rho}"),
  c("\uD6D3", "\\\\mathbf{\\\\varsigma}"),
  c("\uD6D4", "\\\\mathbf{\\\\Sigma}"),
  c("\uD6D5", "\\\\mathbf{\\\\Tau}"),
  c("\uD6D6", "\\\\mathbf{\\\\Upsilon}"),
  c("\uD6D7", "\\\\mathbf{\\\\Phi}"),
  c("\uD6D8", "\\\\mathbf{\\\\Chi}"),
  c("\uD6D9", "\\\\mathbf{\\\\Psi}"),
  c("\uD6DA", "\\\\mathbf{\\\\Omega}"),
  c("\uD6DB", "\\\\partial{}"),
  c("\uD6DC", "\\\\in"),
  c("\uD6DD", "\\\\mathbf{\\\\vartheta}"),
  c("\uD6DE", "\\\\mathbf{\\\\varkappa}"),
  c("\uD6DF", "\\\\mathbf{\\\\phi}"),
  c("\uD6E0", "\\\\mathbf{\\\\varrho}"),
  c("\uD6E1", "\\\\mathbf{\\\\varpi}"),
  c("\uD6E2", "\\\\mathsl{\\\\Alpha}"),
  c("\uD6E3", "\\\\mathsl{\\\\Beta}"),
  c("\uD6E4", "\\\\mathsl{\\\\Gamma}"),
  c("\uD6E5", "\\\\mathsl{\\\\Delta}"),
  c("\uD6E6", "\\\\mathsl{\\\\Epsilon}"),
  c("\uD6E7", "\\\\mathsl{\\\\Zeta}"),
  c("\uD6E8", "\\\\mathsl{\\\\Eta}"),
  c("\uD6E9", "\\\\mathsl{\\\\Theta}"),
  c("\uD6EA", "\\\\mathsl{\\\\Iota}"),
  c("\uD6EB", "\\\\mathsl{\\\\Kappa}"),
  c("\uD6EC", "\\\\mathsl{\\\\Lambda}"),
  c("\uD6EF", "\\\\mathsl{\\\\Xi}"),
  c("\uD6F1", "\\\\mathsl{\\\\Pi}"),
  c("\uD6F2", "\\\\mathsl{\\\\Rho}"),
  c("\uD6F3", "\\\\mathsl{\\\\vartheta}"),
  c("\uD6F4", "\\\\mathsl{\\\\Sigma}"),
  c("\uD6F5", "\\\\mathsl{\\\\Tau}"),
  c("\uD6F6", "\\\\mathsl{\\\\Upsilon}"),
  c("\uD6F7", "\\\\mathsl{\\\\Phi}"),
  c("\uD6F8", "\\\\mathsl{\\\\Chi}"),
  c("\uD6F9", "\\\\mathsl{\\\\Psi}"),
  c("\uD6FA", "\\\\mathsl{\\\\Omega}"),
  c("\uD6FB", "\\\\mathsl{\\\\nabla}"),
  c("\uD6FC", "\\\\mathsl{\\\\Alpha}"),
  c("\uD6FD", "\\\\mathsl{\\\\Beta}"),
  c("\uD6FE", "\\\\mathsl{\\\\Gamma}"),
  c("\uD6FF", "\\\\mathsl{\\\\Delta}"),
  c("\uD700", "\\\\mathsl{\\\\Epsilon}"),
  c("\uD701", "\\\\mathsl{\\\\Zeta}"),
  c("\uD702", "\\\\mathsl{\\\\Eta}"),
  c("\uD703", "\\\\mathsl{\\\\Theta}"),
  c("\uD704", "\\\\mathsl{\\\\Iota}"),
  c("\uD705", "\\\\mathsl{\\\\Kappa}"),
  c("\uD706", "\\\\mathsl{\\\\Lambda}"),
  c("\uD709", "\\\\mathsl{\\\\Xi}"),
  c("\uD70B", "\\\\mathsl{\\\\Pi}"),
  c("\uD70C", "\\\\mathsl{\\\\Rho}"),
  c("\uD70D", "\\\\mathsl{\\\\varsigma}"),
  c("\uD70E", "\\\\mathsl{\\\\Sigma}"),
  c("\uD70F", "\\\\mathsl{\\\\Tau}"),
  c("\uD710", "\\\\mathsl{\\\\Upsilon}"),
  c("\uD711", "\\\\mathsl{\\\\Phi}"),
  c("\uD712", "\\\\mathsl{\\\\Chi}"),
  c("\uD713", "\\\\mathsl{\\\\Psi}"),
  c("\uD714", "\\\\mathsl{\\\\Omega}"),
  c("\uD715", "\\\\partial{}"),
  c("\uD716", "\\\\in"),
  c("\uD717", "\\\\mathsl{\\\\vartheta}"),
  c("\uD718", "\\\\mathsl{\\\\varkappa}"),
  c("\uD719", "\\\\mathsl{\\\\phi}"),
  c("\uD71A", "\\\\mathsl{\\\\varrho}"),
  c("\uD71B", "\\\\mathsl{\\\\varpi}"),
  c("\uD71C", "\\\\mathbit{\\\\Alpha}"),
  c("\uD71D", "\\\\mathbit{\\\\Beta}"),
  c("\uD71E", "\\\\mathbit{\\\\Gamma}"),
  c("\uD71F", "\\\\mathbit{\\\\Delta}"),
  c("\uD720", "\\\\mathbit{\\\\Epsilon}"),
  c("\uD721", "\\\\mathbit{\\\\Zeta}"),
  c("\uD722", "\\\\mathbit{\\\\Eta}"),
  c("\uD723", "\\\\mathbit{\\\\Theta}"),
  c("\uD724", "\\\\mathbit{\\\\Iota}"),
  c("\uD725", "\\\\mathbit{\\\\Kappa}"),
  c("\uD726", "\\\\mathbit{\\\\Lambda}"),
  c("\uD729", "\\\\mathbit{\\\\Xi}"),
  c("\uD72B", "\\\\mathbit{\\\\Pi}"),
  c("\uD72C", "\\\\mathbit{\\\\Rho}"),
  c("\uD72D", "\\\\mathbit{O}"),
  c("\uD72E", "\\\\mathbit{\\\\Sigma}"),
  c("\uD72F", "\\\\mathbit{\\\\Tau}"),
  c("\uD730", "\\\\mathbit{\\\\Upsilon}"),
  c("\uD731", "\\\\mathbit{\\\\Phi}"),
  c("\uD732", "\\\\mathbit{\\\\Chi}"),
  c("\uD733", "\\\\mathbit{\\\\Psi}"),
  c("\uD734", "\\\\mathbit{\\\\Omega}"),
  c("\uD735", "\\\\mathbit{\\\\nabla}"),
  c("\uD736", "\\\\mathbit{\\\\Alpha}"),
  c("\uD737", "\\\\mathbit{\\\\Beta}"),
  c("\uD738", "\\\\mathbit{\\\\Gamma}"),
  c("\uD739", "\\\\mathbit{\\\\Delta}"),
  c("\uD73A", "\\\\mathbit{\\\\Epsilon}"),
  c("\uD73B", "\\\\mathbit{\\\\Zeta}"),
  c("\uD73C", "\\\\mathbit{\\\\Eta}"),
  c("\uD73D", "\\\\mathbit{\\\\Theta}"),
  c("\uD73E", "\\\\mathbit{\\\\Iota}"),
  c("\uD73F", "\\\\mathbit{\\\\Kappa}"),
  c("\uD740", "\\\\mathbit{\\\\Lambda}"),
  c("\uD743", "\\\\mathbit{\\\\Xi}"),
  c("\uD745", "\\\\mathbit{\\\\Pi}"),
  c("\uD746", "\\\\mathbit{\\\\Rho}"),
  c("\uD747", "\\\\mathbit{\\\\varsigma}"),
  c("\uD748", "\\\\mathbit{\\\\Sigma}"),
  c("\uD749", "\\\\mathbit{\\\\Tau}"),
  c("\uD74A", "\\\\mathbit{\\\\Upsilon}"),
  c("\uD74B", "\\\\mathbit{\\\\Phi}"),
  c("\uD74C", "\\\\mathbit{\\\\Chi}"),
  c("\uD74D", "\\\\mathbit{\\\\Psi}"),
  c("\uD74E", "\\\\mathbit{\\\\Omega}"),
  c("\uD74F", "\\\\partial{}"),
  c("\uD750", "\\\\in"),
  c("\uD751", "\\\\mathbit{\\\\vartheta}"),
  c("\uD752", "\\\\mathbit{\\\\varkappa}"),
  c("\uD753", "\\\\mathbit{\\\\phi}"),
  c("\uD754", "\\\\mathbit{\\\\varrho}"),
  c("\uD755", "\\\\mathbit{\\\\varpi}"),
  c("\uD756", "\\\\mathsfbf{\\\\Alpha}"),
  c("\uD757", "\\\\mathsfbf{\\\\Beta}"),
  c("\uD758", "\\\\mathsfbf{\\\\Gamma}"),
  c("\uD759", "\\\\mathsfbf{\\\\Delta}"),
  c("\uD75A", "\\\\mathsfbf{\\\\Epsilon}"),
  c("\uD75B", "\\\\mathsfbf{\\\\Zeta}"),
  c("\uD75C", "\\\\mathsfbf{\\\\Eta}"),
  c("\uD75D", "\\\\mathsfbf{\\\\Theta}"),
  c("\uD75E", "\\\\mathsfbf{\\\\Iota}"),
  c("\uD75F", "\\\\mathsfbf{\\\\Kappa}"),
  c("\uD760", "\\\\mathsfbf{\\\\Lambda}"),
  c("\uD763", "\\\\mathsfbf{\\\\Xi}"),
  c("\uD765", "\\\\mathsfbf{\\\\Pi}"),
  c("\uD766", "\\\\mathsfbf{\\\\Rho}"),
  c("\uD767", "\\\\mathsfbf{\\\\vartheta}"),
  c("\uD768", "\\\\mathsfbf{\\\\Sigma}"),
  c("\uD769", "\\\\mathsfbf{\\\\Tau}"),
  c("\uD76A", "\\\\mathsfbf{\\\\Upsilon}"),
  c("\uD76B", "\\\\mathsfbf{\\\\Phi}"),
  c("\uD76C", "\\\\mathsfbf{\\\\Chi}"),
  c("\uD76D", "\\\\mathsfbf{\\\\Psi}"),
  c("\uD76E", "\\\\mathsfbf{\\\\Omega}"),
  c("\uD76F", "\\\\mathsfbf{\\\\nabla}"),
  c("\uD770", "\\\\mathsfbf{\\\\Alpha}"),
  c("\uD771", "\\\\mathsfbf{\\\\Beta}"),
  c("\uD772", "\\\\mathsfbf{\\\\Gamma}"),
  c("\uD773", "\\\\mathsfbf{\\\\Delta}"),
  c("\uD774", "\\\\mathsfbf{\\\\Epsilon}"),
  c("\uD775", "\\\\mathsfbf{\\\\Zeta}"),
  c("\uD776", "\\\\mathsfbf{\\\\Eta}"),
  c("\uD777", "\\\\mathsfbf{\\\\Theta}"),
  c("\uD778", "\\\\mathsfbf{\\\\Iota}"),
  c("\uD779", "\\\\mathsfbf{\\\\Kappa}"),
  c("\uD77A", "\\\\mathsfbf{\\\\Lambda}"),
  c("\uD77D", "\\\\mathsfbf{\\\\Xi}"),
  c("\uD77F", "\\\\mathsfbf{\\\\Pi}"),
  c("\uD780", "\\\\mathsfbf{\\\\Rho}"),
  c("\uD781", "\\\\mathsfbf{\\\\varsigma}"),
  c("\uD782", "\\\\mathsfbf{\\\\Sigma}"),
  c("\uD783", "\\\\mathsfbf{\\\\Tau}"),
  c("\uD784", "\\\\mathsfbf{\\\\Upsilon}"),
  c("\uD785", "\\\\mathsfbf{\\\\Phi}"),
  c("\uD786", "\\\\mathsfbf{\\\\Chi}"),
  c("\uD787", "\\\\mathsfbf{\\\\Psi}"),
  c("\uD788", "\\\\mathsfbf{\\\\Omega}"),
  c("\uD789", "\\\\partial{}"),
  c("\uD78A", "\\\\in"),
  c("\uD78B", "\\\\mathsfbf{\\\\vartheta}"),
  c("\uD78C", "\\\\mathsfbf{\\\\varkappa}"),
  c("\uD78D", "\\\\mathsfbf{\\\\phi}"),
  c("\uD78E", "\\\\mathsfbf{\\\\varrho}"),
  c("\uD78F", "\\\\mathsfbf{\\\\varpi}"),
  c("\uD790", "\\\\mathsfbfsl{\\\\Alpha}"),
  c("\uD791", "\\\\mathsfbfsl{\\\\Beta}"),
  c("\uD792", "\\\\mathsfbfsl{\\\\Gamma}"),
  c("\uD793", "\\\\mathsfbfsl{\\\\Delta}"),
  c("\uD794", "\\\\mathsfbfsl{\\\\Epsilon}"),
  c("\uD795", "\\\\mathsfbfsl{\\\\Zeta}"),
  c("\uD796", "\\\\mathsfbfsl{\\\\Eta}"),
  c("\uD797", "\\\\mathsfbfsl{\\\\vartheta}"),
  c("\uD798", "\\\\mathsfbfsl{\\\\Iota}"),
  c("\uD799", "\\\\mathsfbfsl{\\\\Kappa}"),
  c("\uD79A", "\\\\mathsfbfsl{\\\\Lambda}"),
  c("\uD79D", "\\\\mathsfbfsl{\\\\Xi}"),
  c("\uD79F", "\\\\mathsfbfsl{\\\\Pi}"),
  c("\uD7A0", "\\\\mathsfbfsl{\\\\Rho}"),
  c("\uD7A1", "\\\\mathsfbfsl{\\\\vartheta}"),
  c("\uD7A2", "\\\\mathsfbfsl{\\\\Sigma}"),
  c("\uD7A3", "\\\\mathsfbfsl{\\\\Tau}"),
  c("\uD7A4", "\\\\mathsfbfsl{\\\\Upsilon}"),
  c("\uD7A5", "\\\\mathsfbfsl{\\\\Phi}"),
  c("\uD7A6", "\\\\mathsfbfsl{\\\\Chi}"),
  c("\uD7A7", "\\\\mathsfbfsl{\\\\Psi}"),
  c("\uD7A8", "\\\\mathsfbfsl{\\\\Omega}"),
  c("\uD7A9", "\\\\mathsfbfsl{\\\\nabla}"),
  c("\uD7AA", "\\\\mathsfbfsl{\\\\Alpha}"),
  c("\uD7AB", "\\\\mathsfbfsl{\\\\Beta}"),
  c("\uD7AC", "\\\\mathsfbfsl{\\\\Gamma}"),
  c("\uD7AD", "\\\\mathsfbfsl{\\\\Delta}"),
  c("\uD7AE", "\\\\mathsfbfsl{\\\\Epsilon}"),
  c("\uD7AF", "\\\\mathsfbfsl{\\\\Zeta}"),
  c("\uD7B0", "\\\\mathsfbfsl{\\\\Eta}"),
  c("\uD7B1", "\\\\mathsfbfsl{\\\\vartheta}"),
  c("\uD7B2", "\\\\mathsfbfsl{\\\\Iota}"),
  c("\uD7B3", "\\\\mathsfbfsl{\\\\Kappa}"),
  c("\uD7B4", "\\\\mathsfbfsl{\\\\Lambda}"),
  c("\uD7B7", "\\\\mathsfbfsl{\\\\Xi}"),
  c("\uD7B9", "\\\\mathsfbfsl{\\\\Pi}"),
  c("\uD7BA", "\\\\mathsfbfsl{\\\\Rho}"),
  c("\uD7BB", "\\\\mathsfbfsl{\\\\varsigma}"),
  c("\uD7BC", "\\\\mathsfbfsl{\\\\Sigma}"),
  c("\uD7BD", "\\\\mathsfbfsl{\\\\Tau}"),
  c("\uD7BE", "\\\\mathsfbfsl{\\\\Upsilon}"),
  c("\uD7BF", "\\\\mathsfbfsl{\\\\Phi}"),
  c("\uD7C0", "\\\\mathsfbfsl{\\\\Chi}"),
  c("\uD7C1", "\\\\mathsfbfsl{\\\\Psi}"),
  c("\uD7C2", "\\\\mathsfbfsl{\\\\Omega}"),
  c("\uD7C3", "\\\\partial{}"),
  c("\uD7C4", "\\\\in"),
  c("\uD7C5", "\\\\mathsfbfsl{\\\\vartheta}"),
  c("\uD7C6", "\\\\mathsfbfsl{\\\\varkappa}"),
  c("\uD7C7", "\\\\mathsfbfsl{\\\\phi}"),
  c("\uD7C8", "\\\\mathsfbfsl{\\\\varrho}"),
  c("\uD7C9", "\\\\mathsfbfsl{\\\\varpi}"),
  c("\uD7CE", "\\\\mathbf{0}"),
  c("\uD7CF", "\\\\mathbf{1}"),
  c("\uD7D0", "\\\\mathbf{2}"),
  c("\uD7D1", "\\\\mathbf{3}"),
  c("\uD7D2", "\\\\mathbf{4}"),
  c("\uD7D3", "\\\\mathbf{5}"),
  c("\uD7D4", "\\\\mathbf{6}"),
  c("\uD7D5", "\\\\mathbf{7}"),
  c("\uD7D6", "\\\\mathbf{8}"),
  c("\uD7D7", "\\\\mathbf{9}"),
  c("\uD7D8", "\\\\mathbb{0}"),
  c("\uD7D9", "\\\\mathbb{1}"),
  c("\uD7DA", "\\\\mathbb{2}"),
  c("\uD7DB", "\\\\mathbb{3}"),
  c("\uD7DC", "\\\\mathbb{4}"),
  c("\uD7DD", "\\\\mathbb{5}"),
  c("\uD7DE", "\\\\mathbb{6}"),
  c("\uD7DF", "\\\\mathbb{7}"),
  c("\uD7E0", "\\\\mathbb{8}"),
  c("\uD7E1", "\\\\mathbb{9}"),
  c("\uD7E2", "\\\\mathsf{0}"),
  c("\uD7E3", "\\\\mathsf{1}"),
  c("\uD7E4", "\\\\mathsf{2}"),
  c("\uD7E5", "\\\\mathsf{3}"),
  c("\uD7E6", "\\\\mathsf{4}"),
  c("\uD7E7", "\\\\mathsf{5}"),
  c("\uD7E8", "\\\\mathsf{6}"),
  c("\uD7E9", "\\\\mathsf{7}"),
  c("\uD7EA", "\\\\mathsf{8}"),
  c("\uD7EB", "\\\\mathsf{9}"),
  c("\uD7EC", "\\\\mathsfbf{0}"),
  c("\uD7ED", "\\\\mathsfbf{1}"),
  c("\uD7EE", "\\\\mathsfbf{2}"),
  c("\uD7EF", "\\\\mathsfbf{3}"),
  c("\uD7F0", "\\\\mathsfbf{4}"),
  c("\uD7F1", "\\\\mathsfbf{5}"),
  c("\uD7F2", "\\\\mathsfbf{6}"),
  c("\uD7F3", "\\\\mathsfbf{7}"),
  c("\uD7F4", "\\\\mathsfbf{8}"),
  c("\uD7F5", "\\\\mathsfbf{9}"),
  c("\uD7F6", "\\\\mathtt{0}"),
  c("\uD7F7", "\\\\mathtt{1}"),
  c("\uD7F8", "\\\\mathtt{2}"),
  c("\uD7F9", "\\\\mathtt{3}"),
  c("\uD7FA", "\\\\mathtt{4}"),
  c("\uD7FB", "\\\\mathtt{5}"),
  c("\uD7FC", "\\\\mathtt{6}"),
  c("\uD7FD", "\\\\mathtt{7}"),
  c("\uD7FE", "\\\\mathtt{8}"),
  c("\uD7FF", "\\\\mathtt{9}"),
  c("\uFB00", "ff"),
  c("\uFB01", "fi"),
  c("\uFB02", "fl"),
  c("\uFB03", "ffi"),
  c("\uFB04", "ffl"),
  c("\uFB05", "\u017ft"),
  c("\uFB06", "st"),

  ###################################################
  # Remaining Special Handling
  c("(?![[:space:]])[[:cntrl:]]", ""), # Remove control characters remaining
  c("[[:space:]]+", " "),              # Convert any sequence of whitespace to a single space.

  c("\\\\\\\\", "\\\\textbackslash{}"), # Deferred backslash escape from above list

  # Subset of markdown syntax
  c("\\*\\*([^\\*]+)\\*\\*",  "\\\\textbf{\\1}"), # Bold
  c("__([^_]+)__",            "\\\\textbf{\\1}"),
  c("\\*([^\\*]+)\\*",        "\\\\textit{\\1}"), # Italic
  c("_([^_]+)_",              "\\\\textit{\\1}"),
  c("`([^`]+)`",              "\\\\texttt{\\1}"), # Inline Code
  c("~~([^~]+)~~",            "\\\\sout{\\1}"),   # Strikethrough (require ulem package)
  c("~([^~]+)~",              "\\\\textsubscript{\\1}"),           # Subscript
  c("\u00A0",                 "~"),               # no-break space (NBSP) must be handled after subscripting
  c("\\^([^\\^]+)\\^",        "\\\\textsuperscript{\\1}"),          # Superscript

  c("^# (.*)",                "\\\\Huge{\\1}"),   # Header 1
  c("^## (.*)",               "\\\\huge{\\1}"),   # Header 2
  c("^### (.*)",              "\\\\LARGE{\\1}"),  # Header 3
  c("^#### (.*)",             "\\\\Large{\\1}"),  # Header 4
  c("^##### (.*)",            "\\\\large{\\1}"),  # Header 5
  c("^###### (.*)",           "\\1"),             # Header 6

  c("---",                    "\\\\textemdash{}"),
  c("--",                     "\\\\textendash{}"),
  c("\\.\\.\\.",              "\\\\ldots{}"),
  c("\\*\\*\\*",              "\\\\hrule{}")
)


# dplR::latexify 1.6.6 modified heavily for use in tangram
# Copyright (C) 2017 Andy Bunn
# Copyright (C) 2017 Shawn Garbett, modifications
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

## Usage: \Sexpr{latexify(string_produced_by_R_code)}
##
## It seems that Sweave needs doublebackslash = TRUE
## but knitr needs doublebackslash = FALSE.
#' @include render-latex-map.R
#' @importFrom stringi stri_trans_nfc
#' @importFrom stringi stri_trans_nfd
#' @importFrom utils capture.output
latexify <- function(x)
{
  y <- as.character(x)          # Make sure a character string was passed
  if(nchar(y) == 0) return("")  # Abort early for zero characters

  ## Kludge for converting from "byte" to the current encoding
  ## in a way which preserves the hex notation.
  encBytes <- Encoding(y) == "bytes"
  if (any(encBytes)) y[encBytes] <- capture.output(cat(y[encBytes], sep = "\n"))

  ## Convert strings to UTF-8 encoding, NFD (decomposed) form, for
  ## processing of accented characters. Doing this early to
  ## circumvent pecularities in gsub() (and nchar()) when working in
  ## the C locale.
  y <- stri_trans_nfd(y)

  ## Run all conversions as appropriate not inside "$"
  pieces  <- strsplit(y, "(?<!\\\\)\\$", perl=TRUE)[[1]]
  for(i in 1:length(pieces))
  {
    if( (i %% 2) == 0)
    {
      pieces[i] <- paste0("\\[", pieces[i], "\\]")
    } else # Odd, run gsub conversions
    {
      for (subst in gsub_table) pieces[i] <- gsub(subst[1], subst[2], pieces[i], perl = TRUE)
    }
  }
  y <- paste0(pieces, collapse="")

  ## Convert result to UTF-8 NFC encoding, although most non-ASCII
  ## content has probably been converted to LaTeX commands.
  stri_trans_nfc(y)
}

