% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-html5.R
\name{html5.tangram}
\alias{html5.tangram}
\title{Convert a tangram class into an HTML5 string}
\usage{
\method{html5}{tangram}(object, id = NA, caption = NA, css = NA,
  fragment = TRUE, inline = NA, footnote = NA, ...)
}
\arguments{
\item{object}{The cell table to render to HTML5}

\item{id}{A unique identifier for the table (strongly recommended). If not provided, caption will be used.}

\item{caption}{A string caption for the table}

\item{css}{A string that is the href to the css for complete HTML5}

\item{fragment}{A boolean flag that determines whether a fragment or a complete HTML5 document is generatedf}

\item{inline}{A string containing a filename to include as inline CSS. It first searches the drive for the file, if that fails it looks inside the package for a matching css file.}

\item{footnote}{Any footnotes to include under the table.}

\item{...}{additional arguments to renderer. Unused}
}
\value{
A text string rendering of the given table in HTML5
}
\description{
Given a tangram class, a series of conversion creates an HTML5
representation of the table. It may be an HTML5 fragment or it may
be a complete web page.
}
\details{
The package includes several css files for styling. At present the following exist: 'hmisc.css', 'lancet.css', 'lancet-stripped.css' and 'nejm.css'
}
