% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-cell.R
\name{cell_iqr}
\alias{cell_iqr}
\title{Create a interquartile range cell object of the given data}
\usage{
cell_iqr(x, format = NA, na.rm = TRUE, names = FALSE, type = 8, ...)
}
\arguments{
\item{x}{numeric vector whose sample quantiles are wanted. NA and NaN values are not allowed in numeric vectors unless na.rm is TRUE.}

\item{format}{numeric or character; Significant digits or fmt to pass to sprintf}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before the quantiles are computed.}

\item{names}{logical; if true, the result has a names attribute. Set to FALSE for speedup with many probs.}

\item{type}{integer; specify algorithm to use in constructing quantile. See quantile for more information.}

\item{...}{additional arguments to constructing cell}
}
\value{
A cell_quantile object.
}
\description{
Construct a cell which has the 3 interquartile ranges specified.
}
\examples{
require(stats)
cell_iqr(rnorm(100), '3')
}
