% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-post.R
\name{add_indent}
\alias{add_indent}
\title{Add indentations to left column row headers}
\usage{
add_indent(table, amounts = 2, rows = NULL, columns = NULL)
}
\arguments{
\item{table}{Output of tangram::tangram()}

\item{amounts}{numeric; Specifies number of spaces to add. A vector that is either a single value or vector of the same size as the height of the table. If positions is specified then it must be the same length. Defaults to 2, which each pair of spaces converts naturally in rendering to HTML, LaTeX, etc..}

\item{rows}{numeric; A vector of numeric row numbers for the rows that need to be indented. Defaults to NULL which indents all.}

\item{columns}{numeric; Column to apply indent to, defaults to 1}
}
\value{
the modified table
}
\description{
Add indentations to left column row headers. Note: will only work on cell_header cells.
}
\examples{
x <- tangram(drug ~ bili + albumin, pbc)
add_indent(x)
add_indent(x, amounts=10)
add_indent(x, amounts=c(0, 0, 2, 4))
add_indent(x, rows=c(3))
add_indent(x, rows=c(3, 4), amounts=c(4, 2))
}
