% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_eval_raw.R
\name{tar_eval_raw}
\alias{tar_eval_raw}
\title{Evaluate multiple expressions created with symbol substitution
(raw version).}
\usage{
tar_eval_raw(expr, values, envir = parent.frame())
}
\arguments{
\item{expr}{Expression object with the starting expression.
Values are iteratively substituted
in place of symbols in \code{expr} to create each new expression,
and then each expression is evaluated.}

\item{values}{List of values to substitute into \code{expr} to create
the expressions. All elements of \code{values} must have the same length.}

\item{envir}{Environment in which to evaluate the new expressions.}
}
\value{
A list of return values from evaluating the expression objects.
Often, these values are target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please see the design specification at
\url{https://books.ropensci.org/targets-design/}
to learn about the structure and composition of target objects.
}
\description{
Loop over a grid of values, create an expression object
from each one, and then evaluate that expression.
Helps with general metaprogramming. Unlike \code{\link[=tar_sub]{tar_sub()}},
which quotes the \code{expr} argument, \code{tar_sub_raw()} assumes \code{expr}
is an expression object.
}
\examples{
# tar_map() is incompatible with tar_render() because the latter
# operates on preexisting tar_target() objects. By contrast,
# tar_eval_raw() and tar_sub_raw() iterate over code farther upstream.
values <- list(
  name = rlang::syms(c("name1", "name2")),
  file = c("file1.Rmd", "file2.Rmd")
)
tar_sub_raw(quote(tar_render(name, file)), values = values)
targets::tar_dir({
file.create(c("file1.Rmd", "file2.Rmd"))
str(tar_eval_raw(quote(tar_render(name, file)), values = values))
# So in your _targets.R file, you can define a pipeline like as below.
# Just make sure to set a unique name for each target
# (which tar_map() does automatically).
values <- list(
  name = rlang::syms(c("name1", "name2")),
  file = c("file1.Rmd", "file2.Rmd")
)
list(
  tar_eval_raw(quote(tar_render(name, file)), values = values)
)
})
}
