% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_branches.R
\name{tar_branches}
\alias{tar_branches}
\title{Reconstruct the branch names and the names of their dependencies.}
\usage{
tar_branches(name, pattern, store = targets::tar_config_get("store"))
}
\arguments{
\item{name}{Symbol, name of the target.}

\item{pattern}{Language to define branching for a target.
For example, in a pipeline with numeric vector targets \code{x} and \code{y},
\code{tar_target(z, x + y, pattern = map(x, y))} implicitly defines
branches of \code{z} that each compute \code{x[1] + y[1]}, \code{x[2] + y[2]},
and so on. See the user manual for details.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A \code{tibble} with one row per branch and one column for each target
(including the branched-over targets and the target with the pattern.)
}
\description{
Given a branching pattern, use available metadata
to reconstruct branch names and the names of each
branch's dependencies. The metadata of each target
must already exist and be consistent with the metadata
of the other targets involved.
}
\details{
The results from this function can help you retroactively
figure out correspondences between upstream branches and downstream
branches. However, it does not always correctly predict what the
names of the branches will be after the next run of the pipeline.
Dynamic branching happens while the pipeline is running,
so we cannot always know what the names of the branches will be
in advance (or even how many there will be).
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, head(letters, 2)),
    tar_target(z, head(LETTERS, 2)),
    tar_target(dynamic, c(x, y, z), pattern = cross(z, map(x, y)))
  )
}, ask = FALSE)
tar_make()
tar_branches(dynamic, pattern = cross(z, map(x, y)))
})
}
}
\seealso{
Other branching: 
\code{\link{tar_branch_index}()},
\code{\link{tar_branch_names_raw}()},
\code{\link{tar_branch_names}()},
\code{\link{tar_pattern}()}
}
\concept{branching}
