% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_branch_names_raw.R
\name{tar_branch_names_raw}
\alias{tar_branch_names_raw}
\title{Branch names (raw version)}
\usage{
tar_branch_names_raw(name, index, store = targets::tar_config_get("store"))
}
\arguments{
\item{name}{Character of length 1,
name of the dynamic branching target (pattern).}

\item{index}{Integer vector of branch indexes.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A character vector of branch names.
}
\description{
Get the branch names of a dynamic branching target
using numeric indexes. Same as \code{\link[=tar_branch_names]{tar_branch_names()}} except
\code{name} is a character of length 1.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(w, 1),
    tar_target(x, seq_len(4)),
    tar_target(y, 2 * x, pattern = map(x)),
    tar_target(z, y, pattern = map(y))
  )
}, ask = FALSE)
tar_make()
tar_branch_names_raw("z", c(2, 3))
})
}
}
\seealso{
Other branching: 
\code{\link{tar_branch_index}()},
\code{\link{tar_branch_names}()},
\code{\link{tar_branches}()},
\code{\link{tar_pattern}()}
}
\concept{branching}
