% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_poll.R
\name{tar_poll}
\alias{tar_poll}
\title{Repeatedly poll progress in the R console.}
\usage{
tar_poll(
  interval = 1,
  timeout = Inf,
  fields = c("skipped", "dispatched", "completed", "errored", "canceled", "since"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{interval}{Number of seconds to wait between iterations
of polling progress.}

\item{timeout}{How many seconds to run before exiting.}

\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Print the information in \code{\link[=tar_progress_summary]{tar_progress_summary()}}
at regular intervals.
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(x, seq_len(100)),
    tar_target(y, Sys.sleep(0.1), pattern = map(x))
  )
}, ask = FALSE)
px <- tar_make(callr_function = callr::r_bg, reporter = "silent")
tar_poll()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_canceled}()},
\code{\link{tar_completed}()},
\code{\link{tar_dispatched}()},
\code{\link{tar_errored}()},
\code{\link{tar_progress}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_skipped}()},
\code{\link{tar_watch}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()}
}
\concept{progress}
