% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta_upload.R
\name{tar_meta_upload}
\alias{tar_meta_upload}
\title{Upload local metadata to the cloud.}
\usage{
tar_meta_upload(
  meta = TRUE,
  progress = TRUE,
  process = TRUE,
  crew = TRUE,
  verbose = TRUE,
  strict = FALSE,
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{meta}{Logical of length 1, whether to process the main metadata file
at \verb{_targets/meta/meta}.}

\item{progress}{Logical of length 1, whether to process the progress file at
\verb{_targets/meta/progress}.}

\item{process}{Logical of length 1, whether to process the process file at
\verb{_targets/meta/process}.}

\item{crew}{Logical of length 1, whether to process the \code{crew} file at
\verb{_targets/meta/crew}. Only exists if running \code{targets} with \code{crew}.}

\item{verbose}{Logical of length 1, whether to print informative
console messages.}

\item{strict}{Logical of length 1. \code{TRUE} to error out if the file
does not exist locally, \code{FALSE} to proceed without an error or
warning. If \code{strict} is \code{FALSE} and \code{verbose} is \code{TRUE},
then an informative message will print to the R console.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
Upload local metadata files to the cloud location
(repository, bucket, and prefix) you set in
\code{\link[=tar_option_set]{tar_option_set()}} in \verb{_targets.R}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
}, ask = FALSE)
tar_make()
tar_meta_upload()
})
}
}
\seealso{
Other metadata: 
\code{\link{tar_meta}()},
\code{\link{tar_meta_delete}()},
\code{\link{tar_meta_download}()},
\code{\link{tar_meta_sync}()}
}
\concept{metadata}
