% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{arrange_taxa}
\alias{arrange_taxa}
\title{Sort the edge list of \code{\link[=taxmap]{taxmap()}} objects}
\arguments{
\item{obj}{\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}}

\item{...}{One or more expressions (e.g. column names) to sort on. Any
variable name that appears in \code{\link[=all_names]{all_names()}} can be used as if it was a
vector on its own.}
}
\value{
An object of type \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}
}
\description{
Sort the edge list and taxon list in \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} objects. See
\code{\link[dplyr:arrange]{dplyr::arrange()}} for the inspiration for this function and more
information. Calling the function using the \code{obj$arrange_taxa(...)} style
edits "obj" in place, unlike most R functions. However, calling the function
using the \code{arrange_taxa(obj, ...)} imitates R's traditional copy-on-modify
semantics, so "obj" would not be changed; instead a changed version would be
returned, like most R functions.
\preformatted{
obj$arrange_taxa(...)
arrange_taxa(obj, ...)}
}
\examples{
# Sort taxa in ascending order
arrange_taxa(ex_taxmap, taxon_names)

# Sort taxa in decending order
arrange_taxa(ex_taxmap, desc(taxon_names))

# Sort using an expression. List genera first.
arrange_taxa(ex_taxmap, taxon_ranks != "genus")

}
\seealso{
Other taxmap manipulation functions: \code{\link{arrange_obs}},
  \code{\link{filter_obs}}, \code{\link{filter_taxa}},
  \code{\link{mutate_obs}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{transmute_obs}}
}
\concept{taxmap manipulation functions}
