% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxon_authority.R, R/taxonomy.R
\name{tax_date.taxa_classification}
\alias{tax_date.taxa_classification}
\alias{tax_date<-.taxa_classification}
\alias{tax_date}
\alias{tax_date<-}
\alias{tax_date.taxa_taxon}
\alias{tax_date<-.taxa_taxon}
\alias{tax_date<-.taxa_taxon_authority}
\alias{tax_date.taxa_taxon_authority}
\alias{tax_date.taxa_taxonomy}
\alias{tax_date<-.taxa_taxonomy}
\title{Set and get taxon authority dates}
\usage{
\method{tax_date}{taxa_classification}(x)

\method{tax_date}{taxa_classification}(x) <- value

tax_date(x)

tax_date(x) <- value

\method{tax_date}{taxa_taxon}(x)

\method{tax_date}{taxa_taxon}(x) <- value

\method{tax_date}{taxa_taxon_authority}(x) <- value

\method{tax_date}{taxa_taxon_authority}(x)

\method{tax_date}{taxa_taxonomy}(x)

\method{tax_date}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon authority dates.}

\item{value}{The taxon authority dates to set. Inputs will be coerced into a \link{character} vector.}
}
\description{
Set and get the taxon authority dates in objects that have them, such as \link{taxon_authority} objects.
}
\examples{
x <- taxon_authority(c('Cham. & Schldl.', 'L.'),
                     date = c('1827', '1753'))
tax_date(x)
tax_date(x)[1] <- "1984"
tax_date(x) <- c(NA, '1800')

}
