% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nbn_search.R
\name{nbn_search}
\alias{nbn_search}
\title{Search UK National Biodiversity Network database}
\usage{
nbn_search(q, prefered = FALSE, order = "asc", sort = NULL, start = 0,
  rows = 25, taxonOutputGroupKey = NULL, all = FALSE, ...)
}
\arguments{
\item{q}{(character) The query terms(s)}

\item{prefered}{(logical) Restrict search to preferred or any}

\item{order}{(character) The order in which we should sort the results. Default: asc}

\item{sort}{(character) Sort the results or not.}

\item{start}{(integer/numeric) The page that the user wants to start displaying the results at.
Default: 0}

\item{rows}{(integer/numeric) The number of rows to show in each page of search results.
Default: 25}

\item{taxonOutputGroupKey}{(character) Vector of taxon output groups.}

\item{all}{(logical) Get all results, overrides rows parameter if TRUE. Default: FALSE}

\item{...}{Further args passed on to \code{\link[httr]{GET}}.}
}
\description{
Search UK National Biodiversity Network database
}
\examples{
\dontrun{
nbn_search(q = "blackbird")
nbn_search(q = "blackbird", start = TRUE)
nbn_search(q = "blackbird", all = TRUE)
nbn_search(q = "blackbird", taxonOutputGroupKey = "NHMSYS0000080039")

# debug curl stuff
library('httr')
nbn_search(q = "blackbird", config = verbose())
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}

