% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ubio_search.R
\name{ubio_search}
\alias{ubio_search}
\title{This function will return NameBankIDs that match given search terms}
\usage{
ubio_search(searchName = NULL, searchAuth = NULL, searchYear = NULL,
  order = NULL, sci = 1, vern = 1, keyCode = NULL, ...)
}
\arguments{
\item{searchName}{(character) - term to search within name string}

\item{searchAuth}{(character) - term to search within name authorship}

\item{searchYear}{(character) - term to search within name year}

\item{order}{(character) - (name or namebankID) field by which the results will
be sorted (default is namebankID)}

\item{sci}{(integer) - O (no) or 1 (yes; default) to include scientific name results
(default is all)}

\item{vern}{(integer) - O (no) or 1 (yes; default) to include common name (vernacular) results}

\item{keyCode}{(character) Your uBio API key; loads from .Rprofile. If you don't have
one, obtain one at http://www.ubio.org/index.php?pagename=form.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame.
}
\description{
This function will return NameBankIDs that match given search terms
}
\examples{
\dontrun{
ubio_search(searchName = 'elephant')
ubio_search(searchName = 'elephant', sci = 1, vern = 0)
ubio_search(searchName = 'Astragalus aduncus', sci = 1, vern = 0)
ubio_search(searchName = 'puma concolor', sci=1, vern=0)
}
}

