% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iucn_id.R
\name{iucn_id}
\alias{iucn_id}
\title{Get an ID for a IUCN listed taxon}
\usage{
iucn_id(sciname)
}
\arguments{
\item{sciname}{character; Scientific name. Should be cleand and in the
format \emph{<Genus> <Species>}. One or more.}
}
\value{
A vector of one or more numeric IDs. Warnings are thrown
when the taxon is not found
}
\description{
Get an ID for a IUCN listed taxon
}
\examples{
\dontrun{
iucn_id("Branta canadensis")
iucn_id("Branta bernicla")
iucn_id("Panthera uncia")
iucn_id("Lynx lynx")

# many names
iucn_id(c("Panthera uncia", "Lynx lynx"))

# many names, some not found
iucn_id(c("Panthera uncia", "Lynx lynx", "foo bar", "hello world"))

# a name not found
iucn_id("Foo bar")
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}

