% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantminer.R
\name{plantminer}
\alias{plantminer}
\title{Search for taxonomy data from Plantminer.com}
\usage{
plantminer(plants, from = "tpl", key = NULL, verbose = TRUE)
}
\arguments{
\item{plants}{(character) Vector of plant species names. Required.}

\item{from}{(character) One of tpl (for theplantlist.com data), or
flora (for Brazilian Flora Checklist). Required. Deafult: \code{tpl}}

\item{key}{(character) Your api key for the plantminer.com site.  Go to
http://www.plantminer.com/ to get your api key.  Two options for
inputting your key.  1) You can input it manually within the function as
the second argument, or 2) you can put the key in your .Rprofile file,
which will then be loaded when you start R. See
http://bit.ly/135eG0b for help on how to put api keys in your .Rprofile file.}

\item{verbose}{(logical) Verbose or not. Deafult: \code{TRUE}}
}
\value{
data.frame of results.
}
\description{
Search for taxonomy data from Plantminer.com
}
\examples{
\dontrun{
# A single taxon
plantminer("Ocotea pulchella")

# Many taxa
plants <- c("Myrcia lingua", "Myrcia bella", "Ocotea pulchella",
		"Miconia", "Coffea arabica var. amarella", "Bleh")
plantminer(plants)

# By deafult, tpl is used, for Theplantlist data,
# toggle the from parameter here
plantminer("Ocotea pulchella", from = "flora")
}
}

