% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_search_paginate.R
\name{col_search_paginate}
\alias{col_search_paginate}
\title{col_search wrapper to iterate to get more than default results}
\usage{
col_search_paginate(name = NULL, id = NULL, start = NULL,
  checklist = NULL, response = "terse", ...)
}
\arguments{
\item{name}{The string to search for. Only exact matches found the name given
will be returned, unless one or wildcards are included in the search
string. An * (asterisk) character denotes a wildcard; a percent
character may also be used. The name must be at least 3 characters long,
not counting wildcard characters.}

\item{id}{The record ID of the specific record to return (only for scientific
names of species or infraspecific taxa)}

\item{start}{The first record to return. If omitted, the results are returned
from the first record (start=0). This is useful if the total number of
results is larger than the maximum number of results returned by a single
Web service query (currently the maximum number of results returned by a
single query is 500 for terse queries and 50 for full queries).}

\item{checklist}{The year of the checklist to query, if you want a specific
year's checklist instead of the lastest as default (numeric).}

\item{response}{(character) one of "terse" or "full"}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
col_search wrapper to iterate to get more than default results
}
\examples{
# col_search_paginate(name = "Poa", response = "full")
}
\keyword{internal}
