% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indented_list.R
\name{indented_list}
\alias{indented_list}
\alias{indented_list,taxlist-method}
\title{Print hierarchical structure in indented lists}
\usage{
indented_list(object, ...)

\S4method{indented_list}{taxlist}(
  object,
  filter,
  keep_children = TRUE,
  keep_parents = TRUE,
  rankless_as,
  indent = " ",
  lead_br = "",
  print = TRUE,
  author = TRUE,
  level = FALSE,
  synonyms = FALSE,
  syn_encl = c("= ", ""),
  secundum,
  alphabetical = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{taxlist} object containing taxonomic concepts.}

\item{...}{Further arguments (not used yet).}

\item{filter}{A character value (optional) that will be matched with the
taxon usage names to produce a subset of 'object'. Note that this filter
will be also applied to synonyms, independent of the argument applied in
parameter 'synonyms'.}

\item{keep_children}{A logical value indicating whether children of matched
concept should be included in the result.}

\item{keep_parents}{A logical value indicating whether parents of matched
concept should be included in the result.}

\item{rankless_as}{A character vector indicating a level (taxonomic rank) to
which rankless taxa may be set before doing the list.}

\item{indent}{Symbol used for indentation. This symbol will be multiplied by
the depth of the taxonomic rank. The default is a blank space.
This can be also provided as a named vector, with a different indentation
symbol for the respective taxonomic ranks.}

\item{lead_br}{Optional line break symbol leading before the indentation.
It may be required for r-markdown documents.}

\item{print}{A logical value indicating whether the indented list should be
printed in the console or not (default = TRUE).}

\item{author}{A logical value indicating whether the author should be printed
with the name (default = TRUE).}

\item{level}{A logical value indicating whether the name of the level
(taxonomic rank) should be included before the name or not
(default = FALSE).}

\item{synonyms}{A logical value indicating whether the synonyms should be
included after accepted names or not (default = FALSE).}

\item{syn_encl}{A character vector of length 2 including the symbols used to
enclose synonyms. First value will be set before the synonyms and second
value, after the synonyms.}

\item{secundum}{A character value matching a name in slot 'taxonViews', which
will be printed as secundum (taxon view). It is not printed by default.}

\item{alphabetical}{A logical value indicating whether taxa may be sorted by
names or by IDs. The default is FALSE, thus taxa are sorted by IDs.
Note that argument TRUE may not work properly if the object contains
homonymous taxa.}
}
\value{
If 'print = TRUE', the indented list is printed in the console. The result,
which is a data frame with the elements used to format the names, can be also
assigned to an object.
}
\description{
Print taxonomic hierarchies (ranks and parent-child relationships) from
\linkS4class{taxlist} objects in an indented list.
}
\examples{
## Show taxonomy of papyrus
indented_list(Easplist, "papyrus")

## Include synonyms and taxon views
indented_list(Easplist, "papyrus", level = TRUE, synonyms = TRUE,
    secundum = "secundum")

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
