% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_object.R
\name{backup_object}
\alias{backup_object}
\alias{load_last}
\title{Make and load backups of R objects}
\usage{
backup_object(
  ...,
  objects = character(),
  file,
  stamp = TRUE,
  overwrite = FALSE
)

load_last(file, fext = ".rda")
}
\arguments{
\item{...}{Names of the objects to be saved (either symbols or character
strings).}

\item{objects}{A character vector indicating the names of objects to be
included in the backup file.}

\item{file}{A character value indicating the name of the backup file, without
the extension.}

\item{stamp}{A logical value indicating whether time should be stamped in the
backup name or not.}

\item{overwrite}{A logical value indicating whether existing files must be
overwritten or not.}

\item{fext}{A character value indicating the file extension (including the
dot symbol).}
}
\value{
An R image with extension \bold{*.rda}.
}
\description{
When work with data becomes risky, the best practice is to produce backup
files.
The function of \code{backup_object} is a wrapper of \code{\link[=save]{save()}}, adding a
time stamp and a suffix to the name of the resulting file (an R image file
with extension \bold{*.rda}).
The function \code{load_last} is adapted to this style, loading the newest
version to the session.
}
\details{
In both functions the argument \code{file} may include either the path
relative to the working directory or the absolute path to the file, excluding
stamps and extension.
For \code{overwrite=FALSE} (the default), a numeric suffix will be added to
the backup's name, if another backup was produced at the same day.
For \code{overwrite=TRUE} no suffix will be included in the file and existing
files will be overwritten.

The function \code{load_last()} will load the newest version among backups
stored in the same folder, provided that the backup name includes a time
stamp.
}
\examples{
## A subset with Pseudognaphalium and relatives
Pseudognaphalium <- subset(x = Easplist, subset = grepl("Pseudognaphalium",
        TaxonName), slot = "names", keep_parents = TRUE)

## Create a backup with date stamp in tempdir
backup_object(Pseudognaphalium, file = file.path(tempdir(), "Pseudonaphalium"))

## The same again
backup_object(Pseudognaphalium, file = file.path(tempdir(), "Pseudonaphalium"))

## Delete object
rm(list = "Pseudognaphalium")

## To load the last backup into a session
load_last(file = file.path(tempdir(), "Pseudonaphalium"))

## Load pre-installed backup
load_last(file.path(path.package("taxlist"), "extdata", "Podocarpus"))
}
\seealso{
\code{\link{save}} \code{\link{load}}.
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
