% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_status}
\alias{get_status}
\title{Filter a custom taxonomy by GBIF taxonomic status/synonym}
\usage{
get_status(x, status = "all")
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{status}{Filter on GBIF assigned status (i.e. NA, "doubtful", "accepted", "proparte synonym", "synonym", "homotypic synonym",
"heterotypic synonym"). Can be a string or a vector of strings. Defaults to no filtering.}
}
\value{
A filtered tibble.
}
\description{
Filter a custom taxonomy by GBIF taxonomic status/synonym
}
\examples{
get_status(load_sample(), "synonym")
get_status(load_sample(), c("accepted", "doubtful"))
}
