% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{condenseTaxa}
\alias{condenseTaxa}
\title{Condense a taxa table for a single read}
\usage{
condenseTaxa(taxaTable)
}
\arguments{
\item{taxaTable}{a matrix or data.frame with hits on the rows and various levels of taxonomy in the columns}
}
\value{
a vector of length \code{ncol(taxaTable)} with NAs where the is not complete agreement
}
\description{
Take a table of taxonomic assignments from hits to a single read and condense it to a single vector with NAs where there are disagreements between the hits
}
\examples{
taxas<-matrix(c(
 'a','b','c','e',
 'a','b','d','e'
),nrow=2,byrow=TRUE)
condenseTaxa(taxas)
}
