% Generated by roxygen2 (4.0.2): do not edit by hand
\name{column.summary}
\alias{column.summary}
\alias{insertion.stats}
\title{Columns statistics.}
\usage{
column.summary(.data, .factor.col, .target.col, .alphabet = NA, .remove.neg = T)

insertion.stats(.data)
}
\arguments{
\item{.data}{Data frame with columns \code{.factor.col} and \code{target.col}}

\item{.factor.col}{Columns with factors by which the data will be divided to subsets.}

\item{.target.col}{Column with numeric values for computing summaries after dividing the data to subsets.}

\item{.alphabet}{Character vector of factor levels. If NA than use all possible elements frim the \code{.factor.col} column.}

\item{.remove.neg}{Remove all elements which >-1 from the \code{.target.col} column.}
}
\value{
Data.frame with first column with levels of factors and 5 columns with output from the \code{summary} function.
}
\description{
\code{column.summary} - general function for computing summary statistics (using the \code{summary} function) for columns of the given mitcr data.frame:
divide \code{.factor.column} by factors from \code{.alphabet} and compute statistics
of correspondingly divided \code{.target.column}.

\code{insertion.stats} - compute statistics of insertions for the given mitcr data.frame.
}
\examples{
\dontrun{
# Compute summary statistics of VD insertions
# for each V-segment using all V-segments in the given data frame.
column.summary(immdata[[1]], 'V.segments', 'Total.insertions')
# Compute summary statistics of VD insertions for each V-segment using only V-segments
# from the V_BETA_ALPHABET
column.summary(immdata[[1]], 'V.segments', 'Total.insertions', V_BETA_ALPHABET)
}
}
\seealso{
\link{summary}
}

