% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.group.boxplot}
\alias{vis.group.boxplot}
\title{Boxplot for groups of observations.}
\usage{
vis.group.boxplot(.data, .groups = list(A = c("A1", "A2"), D = c("D1", "D2"),
  C = c("C1", "C2")), .labs = c("V segments", "Frequency"), .title = "",
  .rotate.x = T, ...)
}
\arguments{
\item{.data}{Either a matrix with colnames and rownames specifyed or a data frame with the first column of
strings for row names and other columns stands for values.}

\item{.groups}{Named list with character vector for names of elements for each group. If NA than each
member is in the individual group.}

\item{.labs}{Labs names. Character vector of length 1 (for naming both axis with same name) or 2 (first elements stands for x-axis).}

\item{.title}{Main title of the plot.}

\item{.rotate.x}{If T than rotate x-axis.}

\item{...}{Parameters passed to \code{melt}, applied to \code{.data} before plotting in \code{vis.group.boxplot}.}
}
\value{
ggplot object.
}
\description{
Plot boxplots for each group.
}
\examples{
\dontrun{
names(immdata)  # "A1" "A2" "B1" "B2" "C1" "C2"
# Plot a boxplot for V-usage for each plot
# three boxplots for each group.
vis.group.boxplot(freq.Vb(immdata),
   list(A = c('A1', 'A2'), B = c('B1', 'B2'), C = c('C1', 'C2')),
   c('V segments', 'Frequency'))
}
}

