% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{spectratyping}
\alias{spectratyping}
\title{Spectratype plot.}
\usage{
spectratyping(.data, .column = "VD.insertions", .by.alphabet = "Vb",
  .do.legend = T, .draw.only.legend = F, .legend.ncol = -1, .nrow = 2,
  .by.col = "", .sum.col = "Percentage", .other = F, .log = F,
  .verbose = T)
}
\arguments{
\item{.data}{mitcr List with data frames.}

\item{.column}{Character vector with name of the column with numeric characteristic.}

\item{.by.alphabet}{Either 'Va/b', 'Ja/b' or an alphabet.}

\item{.do.legend}{if T then plot a legend.}

\item{.draw.only.legend}{if T then plot only a legend without plots.}

\item{.legend.ncol}{Number of columns in the legend. If -1 than function will try to predict number of columns.}

\item{.nrow}{Rows of grid of plots.}

\item{.by.col}{Character vector with name of the column by which divide the given data frames.}

\item{.sum.col}{Which column use for sum.}

\item{.other}{if T then include in the result plot values which isn't in the given alphabet.}

\item{.log}{if T then scale y-axis by log10.}

\item{.verbose}{if T then print messages about state of the process.}
}
\value{
ggplot object.
}
\description{
General function for making a spectratyping plots.
}
\details{
For each element in \code{.data} do: for each factor in \code{.by.col} which is in \code{.by.alphabet}, compute histogram of \code{.column}
and then plot stacked histogram of distributions of \code{.by.col} for each factor.
}
\examples{
\dontrun{
# Spectratyping of distribution of length of CDR3 nucleotide sequences
# by V-beta-segments.
immdata <- lapply(immdata, function (x) { 
             x$Length <- nchar(x$CDR3.nucleotide.sequence)
             x
           } )
spectratyping(immdata, 'Length', 'Vb')
# Spectratyping of distribution of Total insertions
# by J-beta-segments.
spectratyping(immdata, 'Total.insertions', 'Jb')
}
}

