% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcensReg_llike.R
\name{tcensReg_llike}
\alias{tcensReg_llike}
\title{Log Likelihood for Truncated Normal Distribution with Censoring with Linear Equation Mean}
\usage{
tcensReg_llike(theta, y, X, a = -Inf, v = NULL)
}
\arguments{
\item{theta}{Numeric vector containing estimates of beta and log sigma}

\item{y}{Numeric vector with the observed truncated and censored outcomes}

\item{X}{Numeric design matrix}

\item{a}{Numeric scalar indicating the truncation value}

\item{v}{Numeric scalar indicating the censoring value}
}
\value{
Scalar value of the log-likelihood at the nth iterate
}
\description{
\code{tcensReg_llike} is a supporting function that is used to calculate the log likelihood value at the nth
iteration of theta. If \code{a} and/or \code{v} are not specified then the corresponding censored only, truncated only,
or gaussian log likelihood will be used. This function is called as part of the Newton-Raphson algorithm in \code{tcensReg_newton}.
}
