% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key.R
\name{store_key}
\alias{store_key}
\title{Store API key}
\usage{
store_key(apikey)
}
\arguments{
\item{apikey}{A character variable with the API key}
}
\value{
\code{TRUE} is return invisibly but the function is invoked for the
side effect of storing the API key.
}
\description{
Store the \sQuote{twelvedata} API key
}
\details{
An API key is required to access the functionality offered by the
\sQuote{twelvedata}. This function can store a copy in a per-user
configuration file. It relies on a the base R function \code{R_user_dir}
which offers a per-user configuration directory for the package. No
file or directory permissions are set explicitly or changed. As an
alternative the key can also be set in the environment variable
\code{TWELVEDATA_API_KEY} but doing so is the responsibility of the user.
}
\note{
This function requires R version 4.0.0 or later to utilise the per-user
config directory accessor function. For older R versions, please use the alternate
approach of storying the API in the environment variable \code{TWELVEDATA_API_KEY}.
}
\author{
Dirk Eddelbuettel
}
