% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemniscates.r
\name{lemniscates}
\alias{lemniscates}
\alias{sample_lemniscate_gerono}
\title{Sample (with noise) from lemniscates (figure eights)}
\usage{
sample_lemniscate_gerono(n, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}
}
\description{
These functions generate uniform samples from lemniscates
(figure eights) in 2-dimensional space, optionally with noise.
}
\details{
These functions use a simple parameterization from the unit circle
to the lemniscate of Gerono, as presented on
\href{https://en.wikipedia.org/wiki/Lemniscate_of_Gerono}{Wikipedia}. The
uniform sample is generated through a rejection sampling process as
described by Diaconis, Holmes, and Shahshahani (2013).
}
\examples{
set.seed(12051L)

# Uniformly sampled figure eight in 2-space
x <- sample_lemniscate_gerono(720)
plot(x, asp = 1, pch = 19, cex = .5)

# Naively sampled figure eight, for comparison
theta <- runif(n = 720, min = 0, max = 2*pi)
x_naive <- cbind(x = cos(theta), y <- cos(theta) * sin(theta))
plot(x_naive, asp = 1, pch = 19, cex = .5)

# Uniformly sampled figure eight in 2-space with Gaussian noise
x <- sample_lemniscate_gerono(720, 0.1)
plot(x, asp = 1, pch = 19, cex = .5)
}
\references{
P Diaconis, S Holmes, and M Shahshahani (2013) Sampling from a Manifold.
\emph{Advances in Modern Statistical Theory and Applications: A Festschrift in
honor of Morris L. Eaton}, 102--125. \doi{10.1214/12-IMSCOLL1006}
}
